#include <stdint.h>

#define CHARTYPE unsigned char
#define MAXPAT 51000
#define LIM 65536
#define W 64
#define Q 2

typedef uint64_t bv;

bv pre, B[LIM];
int tr[256], rt[256];
CHARTYPE pattern[MAXPAT];
int patlen, a, b;

void
prep (const CHARTYPE * pat, register int m)
{
  int i, j, r, x, y, x1, x2, i1, i2;

  memcpy (pattern, pat, m);
  patlen = m;

  for (i = 0; i < LIM; i++)
    B[i] = 0;

  for (j = 0; j < 256; ++j)
    tr[j] = 0;
  tr['a'] = 1;
  tr['c'] = 2;
  tr['g'] = 4;
  tr['t'] = 8;
  tr['r'] = 5;
  tr['y'] = 10;
  tr['s'] = 6;
  tr['w'] = 9;
  tr['k'] = 12;
  tr['m'] = 3;
  tr['b'] = 14;
  tr['d'] = 13;
  tr['h'] = 11;
  tr['v'] = 7;
  tr['n'] = 15;

  for (j = 0; j < 256; ++j)
    rt[j] = 0;
  rt[1] = 'a';
  rt[2] = 'c';
  rt[4] = 'g';
  rt[8] = 't';
  rt[5] = 'r';
  rt[10] = 'y';
  rt[6] = 's';
  rt[9] = 'w';
  rt[12] = 'k';
  rt[3] = 'm';
  rt[14] = 'b';
  rt[13] = 'd';
  rt[11] = 'h';
  rt[7] = 'v';
  rt[15] = 'n';

  x = 0;
  if (m <= 4096)
    x = 1;
  a = (m - Q + 1 - x) / W + x;
  r = (m - Q + 1) / a;
  if (r > W)
    r = W;
  y = W - r;
  b = r * a;

  i = m - Q;
  while (i > m - b - Q)
    {
      for (j = 1; j <= a; j++)
        {
          x1 = tr[pattern[i]];
          x2 = tr[pattern[i + 1]];
          for (i1 = 1; i1 < 16; i1++)
            if (x1 & i1)
              for (i2 = 1; i2 < 16; i2++)
                if (x2 & i2)
                  B[(rt[i2] << 8) + rt[i1]] |= (bv) 1 << y;
          i--;
        }
      y++;
    }
}

int
exec (CHARTYPE * t, register int n)
{

  bv d;
  int i, j, k, ki, x = 0, m = patlen, count = 0;

  i = m - 1;
  t[n] = 0;

  while (i < n)
    {
      d = B[*((uint16_t *) (t + i - 1))];
      if (d == 0)
        i += b;
      else
        {
          j = i;
          do
            {
              i -= a;
              d = (d << 1) & B[*((uint16_t *) (t + i - 1))];
            }
          while (d);
          i += b;
          if (i == j)
            {
              for (k = 0; k < a; k++)
                {
                  ki = 0;
                  while (((tr[t[i + ki - m + 1 + k]] &
                           tr[pattern[ki]]) != 0) && (ki < m))
                    ki++;
                  if (ki == m)
                    count++;
                }
              i += a;
            }
        }
    }
  return count;
}
