% [t,h,alpha,delta,w,ux] = widelen(xc,zc,y0, dx,dz,dy0, maxt,pars,K)
%
% Computes approximate wide-region neighborhood step length.
% Does extensive line search only if it pays, that is the resulting
% rate will be at most twice the best possible rate, and the step-length
% at least half of the best possible step length.
% **********  INTERNAL FUNCTION OF SEDUMI **********

function [t,h,alpha,delta,w,ux] = widelen(xc,zc,y0, dx,dz,dy0, maxt,pars,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

 thetaSQR = pars.theta^2;
% --------------------------------------------------
% For descent directions (dy0/y0 < 0), let fullt be
% s.t. y0 + fullt * dy0 = 0     (NB: y0 is duality gap)
% --------------------------------------------------
 if dy0 < -1E-5 * y0
   fullt = y0 / (-dy0);
 else
   fullt = 2*maxt;
 end
 tR = min(maxt, fullt);
% ------------------------------------------------------------
% rate = (y0+t*dy0)/y0 = 1 - (t/fullt) = (fullt - t)/fullt.
% It can never be better than (fullt - tR)/fullt.
% The next criterion ensures that we're never worse than twice best rate'
% ------------------------------------------------------------
 t = 0.0;
 while (t < 0.5 * tR) | ( (fullt-tR) + (1e-7 * fullt) < (tR - t) )
   if tR == maxt                       % Bisection
     tM = 0.1 * t + 0.9 * tR;
   else
     tM = 0.5 * (t + tR);
   end
   xM = xc + tM*dx;
   zM = zc + tM*dz;
% --------------------------------------------------
% Let w = D(xM)*zM, then vlabM = sqrt(eigK(w,K)).
% --------------------------------------------------
   [uxM.qdet,uxM.u,ispos] = factorK(xM,K);
   wM = scaleK(xM,uxM,zM,K);
   wlabM = eigK(wM,K);
   [deltaM,hM,alphaM] = iswnbr(wlabM,thetaSQR);
   if (deltaM <= pars.beta) | ((tM < fullt / 10) & (deltaM < 1))
     ux = uxM; w = wM;
     t = tM; h=hM; alpha=alphaM; delta=deltaM;
   else
     tR = tM;
   end
 end
