% z = veccomplex(x,cpx,K)
% **********  INTERNAL FUNCTION OF SEDUMI **********

function z = veccomplex(x,cpx,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

z = zeros(length(x) - cpx.dim,1);
z(1:K.l) = x(1:K.l);
i = sqrt(-1);
% ----------------------------------------
% LORENTZ: (x1,[x2pr;x2pi]) --> (x1,x2pr + i*x2pi)
% ----------------------------------------
firstk = K.l + 1;
zfirstk = firstk;
k = 1;
for knz = 1:length(cpx.q)
  newk = cpx.q(knz);
  if newk > k
    len = sum(K.q(k:newk-1));
    z(zfirstk:zfirstk+len-1) = x(firstk:firstk+len-1);   % purely real
    zfirstk = zfirstk + len;
    firstk = firstk + len;
  end
  nk = K.q(newk);
  cxnk = (nk+1)/2;
  z(zfirstk) = x(firstk);
  z(zfirstk+1:zfirstk+cxnk-1) = x(firstk+1:firstk+cxnk-1) ...
    + i * x(firstk+cxnk:firstk+nk-1);                  % make complex
  zfirstk = zfirstk + cxnk;
  firstk = firstk + nk;
  k = newk + 1;
end
if k <= length(K.q)
  len = sum(K.q(k:length(K.q)));
  z(zfirstk:zfirstk+len-1) = x(firstk:firstk+len-1);   % remaining blocks
  zfirstk = zfirstk + len;
  firstk = firstk + len;
end
% ----------------------------------------
% PSD:
% ----------------------------------------
hfirstk = firstk + sum(K.s(1:K.rsdpN).^2);       % start of Hermitian blocks
k = 1; sk = 1;
for knz = 1:length(cpx.s)
  newk = cpx.s(knz);
  if newk > k
    len = sum(K.s(sk:sk+newk-k-1).^2);
    z(zfirstk:zfirstk+len-1) = x(firstk:firstk+len-1);  % copy real PSD blocks
    zfirstk = zfirstk + len;
    firstk = firstk + len;
    sk = sk + newk - k;                           % handled newk-k real blocks
  end
  nksqr = K.s(K.rsdpN + knz)^2;                   % insert a Hermitian block
  z(zfirstk:zfirstk+nksqr-1) = x(hfirstk:hfirstk+nksqr-1) ...
    + i * x(hfirstk+nksqr: hfirstk+2*nksqr-1);
  zfirstk = zfirstk + nksqr;
  hfirstk = hfirstk + 2*nksqr;
  k = newk + 1;                                   % handled up to block newk.
end
if sk <= K.rsdpN                                  % copy remaining real blocks
  len = sum(K.s(sk:K.rsdpN).^2);
  z(zfirstk:zfirstk+len-1) = x(firstk:firstk+len-1);
end
