% SPARBWSLV Solves block sparse upper-triangular system.
%    y = sparbwslv(L,b) yields the same result as
%              y(L.perm,:) = L.L'\b
%    However, SPARBWSLV is faster than the built-in operator "\",
%    because it uses dense linear algebra and loop-unrolling on
%    supernodes.
%
%    Typical use, with X sparse m x m positive definite and b is m x n:
%            L = sparchol(symbchol(X),X);
%            L.d(L.dep) = inf;
%            y = sparbwslv(L,sparfwslv(L,b) ./ L.d);
%    Then y solves X*y=b.
%
% SEE ALSO symbchol, sparchol, sparfwslv, \, /.
function y = sparbwslv(L,b)

 y2 = bwslvp(L.U22,L.ph2perm,b(L.ph2nodes));
 y = b - L.U12 * y2;
 y(L.ph2nodes) = y2;
 y = bwblkslv(L,y);
