/*
   y = qscaleK(d,rdetd,x,K)
   Computes y = D(d) x with d in K, Lorentz part.

    This file is part of SeDuMi 1.03BETA
    Copyright (C) 1999 Jos F. Sturm
    Dept. Quantitative Economics, Maastricht University, the Netherlands.
    Affiliations up to SeDuMi 1.02 (AUG1998):
      CRL, McMaster University, Canada.
      Supported by the Netherlands Organization for Scientific Research (NWO).
  
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "mex.h"
#include "triuaux.h"
#include "blksdp.h"

/*    y = scaleK(d,ud,x,K) */

#define Y_OUT plhs[0]
#define NPAROUT 1

#define D_IN prhs[0]
#define RDETD_IN prhs[1]
#define X_IN prhs[2]
#define K_IN prhs[3]
#define NPARIN 4

/* ============================================================
   MAIN: MEXFUNCTION
   ============================================================ */
/* ************************************************************
   PROCEDURE mexFunction - Entry for Matlab
   ************************************************************ */
void mexFunction(const int nlhs, mxArray *plhs[],
  const int nrhs, const mxArray *prhs[])
{
  int i,k, nk;
  double *y;
  const double *d,*rdetd,*x;
  coneK cK;
/* ------------------------------------------------------------
   Check for proper number of arguments 
   ------------------------------------------------------------ */
  if(nrhs < NPARIN)
    mexErrMsgTxt("qscaleK requires more input arguments.");
  if (nlhs > NPAROUT)
    mexErrMsgTxt("qscaleK generates 1 output argument.");
/* ------------------------------------------------------------
   Disassemble cone K structure
   ------------------------------------------------------------ */
  conepars(K_IN, &cK);
/* ------------------------------------------------------------
   Get scale data: (d,rdetd) and input x.
   ------------------------------------------------------------ */
  if(mxGetM(D_IN) * mxGetN(D_IN) < cK.lpN + cK.qDim)
    mexErrMsgTxt("d size mismatch");
  d = mxGetPr(D_IN) + cK.lpN;              /* skip LP part */
  if(mxGetM(RDETD_IN) * mxGetN(RDETD_IN) != cK.lorN)
    mexErrMsgTxt("rdetx size mismatch");
  rdetd = mxGetPr(RDETD_IN);
  if(mxGetM(X_IN) * mxGetN(X_IN) != cK.qDim)
    mexErrMsgTxt("x size mismatch");
  x = mxGetPr(X_IN);
/* ------------------------------------------------------------
   Allocate output Y
   ------------------------------------------------------------ */
  Y_OUT =  mxCreateDoubleMatrix(cK.qDim, 1, mxREAL);
  y = mxGetPr(Y_OUT);
/* ------------------------------------------------------------
   The actual job is done here: y=D(d)x, Lorentz part.
   ------------------------------------------------------------ */
  for(k = 0; k < cK.lorN; k++){               /* LORENTZ */
    nk = cK.lorNL[k];
    qlmul(y, d,x,rdetd[k],nk);
    y += nk; x += nk; d += nk;
  }
}
