% [At,b,c,K,prep] = pretransfo(At,b,c,K)
% Checks data and then transforms into internal SeDuMi format.
% **********  INTERNAL FUNCTION OF SEDUMI **********
function [At,b,c,K,prep] = pretransfo(At,b,c,K)

 %  
 %   This file is part of SeDuMi 1.03BETA
 %   Copyright (C) 1999 Jos F. Sturm
 %   Dept. Quantitative Economics, Maastricht University, the Netherlands.
 %   Affiliations up to SeDuMi 1.02 (AUG1998):
 %     CRL, McMaster University, Canada.
 %     Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

% ----------------------------------------
% Make sure that all fields exist in K-structure
% ----------------------------------------
if ~isfield(K,'l')
  K.l = 0;
elseif isempty(K.l)
  K.l = 0;
elseif (K.l~= floor(K.l)) | (K.l < 0)
  error('K.l should be nonnegative integer')
end
if ~isfield(K,'q')
  K.q = [];
elseif sum(K.q) == 0
  K.q = [];
elseif ~isempty(K.q)
  if (K.q~= floor(K.q)) | min(K.q) < 2
    error('K.q should contain only integers bigger than 1')
  end
  if size(K.q,1) > 1
    K.q = K.q';
  end
end
if ~isfield(K,'r')
  K.r = [];
elseif sum(K.r) == 0
  K.r = [];
elseif ~isempty(K.r)
  if (K.r~= floor(K.r)) | min(K.r) < 3
    error('K.r should contain only integers bigger than 2')
  end
  if size(K.r,1) > 1
    K.r = K.r';
  end
end
if ~isfield(K,'s')
  K.s = [];
elseif sum(K.s) == 0
  K.s = [];
elseif ~isempty(K.s)
  if (K.s~= floor(K.s)) | min(K.s < 1)
    error('K.s should contain only positive integers')
  end
  if size(K.s,1) > 1
    K.s = K.s';
  end
end
if ~isfield(K,'ycomplex')
  K.ycomplex = [];
elseif ~isempty(K.ycomplex)
  if (K.ycomplex~= floor(K.ycomplex)) | min(K.ycomplex < 1)
    error('K.ycomplex should contain only positive integers')
  end
  if size(K.ycomplex,1) > 1
    K.ycomplex = K.ycomplex';
  end
end
% ----------------------------------------
% Check size of At,b,c (w.r.t. K)
% Let m = #eq-constraints, N = #variables (before transformations)
% ----------------------------------------
 if (min(size(b)) > 1) | (min(size(c)) > 1)
   error('Parameters b and c must be vectors')
 end
 m = min(size(At));
 N = K.l + sum(K.q) + sum(K.r) + sum((K.s).^2);
 if nnz(b) == 0
   b = sparse(m,1);
 elseif length(b) ~= m
   error('Size b mismatch')
 end
 if m ~= size(b,1)                    % make b an m x 1 vector
   b = b';
 end
 if nnz(c) == 0
   c = sparse(N,1);
 elseif length(c) ~= N
   error('Size c mismatch')
 end
 if N ~= size(c,1)                     % make c an N x 1 vector
   c = c';
 end
 if size(At,2) ~= m 
   if m == size(At,1)
     At = At';        %user accidentally gave A instead of At.
   else
     error('Size At mismatches b.')
   end
 end
 if size(At,1) ~= N;
   error('Size At mismatches cone K.')
 end
 if ~isempty(K.ycomplex)
   if(max(K.ycomplex) > m)
     error('K.ycomplex out of range')
   end
 end
% ----------------------------------------
% Transform R-cones (rotated Lorentz) into Q-cones (standard Lorentz).
% ----------------------------------------
 prep.lenKq = length(K.q);
 if ~isempty(K.r)
   c = rotlorentz(c,K);
   for i = 1:m
     At(:,i) = rotlorentz(At(:,i),K);
   end
   K.q = [K.q K.r];
   K.r = [];
 end
% ----------------------------------------
% Make "imag(Ax) = imag(b)" and "imag(y)" explicit, as indicated by K.ycomplex
% ----------------------------------------
 [At,b,K.ycomplex] = makeyreal(At,b,K);
% ----------------------------------------
% Correct A s.t. At has tril-blocks (for PSD),
% and remove empty constraints, if any.
% ----------------------------------------
 [At,b,prep.depRows] = correctab(sparse(At),b,K);
% ----------------------------------------
% Transform any complex data into internal format,
% which uses only MATLAB's real representation.
% ----------------------------------------
 [At,c,K,prep.cpx] = makereal(At,c,K);
 K.rsdpN = length(K.s) - length(prep.cpx.s);    % # real symmetric PSD vars
 m = length(b);
% ----------------------------------------
% Now that complex Lorentz cones are transformed to real,
% we need K.q(k) >= 3 for all k.
% ----------------------------------------
 if min(K.q) < 3
   error('The real dimension of each Lorentz cone should be at least 3.')
 end
