% [xp,yp] = posttransfo(x,y,prep,K)
% Transforms (x,y) from internal SeDuMi format into original user format.
% **********  INTERNAL FUNCTION OF SEDUMI **********

function [xp,yp] = posttransfo(x,y,prep,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

% ----------------------------------------
% Bring x into the complex format of original (At,c),
% ----------------------------------------
 K.l = K.l - 1;       % remove artificial var of self-dual embedding
 xp = veccomplex(x,prep.cpx,K);
 qcpx = K.q(prep.cpx.q);
 qcpx = (qcpx+1)/2;
 K.q(prep.cpx.q) = qcpx;
% ----------------------------------------
% transform q-variables into r-variables (Lorentz),
% ----------------------------------------
 K.r = K.q(prep.lenKq + 1 : length(K.q));
 K.q = K.q(1:prep.lenKq);
 xp = rotlorentz(xp,K);
% ----------------------------------------
% bring y into complex format, indicated by K.ycomplex.
% ----------------------------------------
 ylen = length(y) - length(K.ycomplex);
 yp = y(1:ylen) ...
   + sqrt(-1) * sparse(K.ycomplex,1,y(ylen+1:length(y)),ylen,1);
% ----------------------------------------
% add 0's in y where rows were removed.
% ----------------------------------------
 if ~isempty(prep.depRows)
   m = length(y) + length(prep.depRows);
   y0 = yp;
   yp = ones(m,1);
   yp(prep.depRows) = 0;
   yp(find(yp)) = y0;
 end
