% y = invscaleK(d,x,K, auxd)
% Computes y = inv(d) scale x with d in K. (transposed mode)
% auxd = factorK(d,K) if d is full
% auxd = Lorentz frame if d in spectral space.
% **********  INTERNAL FUNCTION OF SEDUMI **********

function y = invscaleK(d,x,K,auxd)
% THE M-FILE VERSION OF THIS FUNCTION IS HERE ONLY AS ILLUSTRATION.
% SEE THE C-SOURCE FOR THE MEX-VERSION.

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

error('At OS prompt, type "make" to create SeDuMi mex-files.')

 y = zeros(length(x),1);
% ----------------------------------------
% LP: y = x ./ d
% ----------------------------------------
 if K.l > 0
   y(1:K.l) = x(1:K.l) ./ d(1:K.l);
 end
 firstk = K.l+1;
% ----------------------------------------
% LORENTZ: y = inv(d) scale x
% (I) d in R^N full: auxd == sqrt(det(d))
% ----------------------------------------
 if length(d) == length(x)
   for k = 1:length(K.q)
     nk = K.q(k); lastk = firstk + nk - 1;
     y(firstk:lastk) = qldiv(d(firstk:lastk),x(firstk:lastk),auxd(k));
     firstk = lastk + 1;
   end
   offud = firstk - 1 - length(K.q);    % next is auxd(firstk - offud)
 else
% ----------------------------------------
% (II) d in R^n spectral: detd = d1*d2, auxd = Lorentz frame
% ----------------------------------------
   nextd = K.l + 1;
   nextf = 1;
   for k = 1:length(K.q)
     nk = K.q(k); lastk = firstk + nk - 1;
     dk = qtofull(auxd(nextf:nextf+nk-2), d(nextd:nextd+1));
     y(firstk:lastk) = qldiv(dk,x(firstk:lastk), sqrt(d(nextd)*d(nextd+1)));
     nextd = nextd + 2; nextf = nextf + nk - 1; firstk = lastk + 1;
   end
 end
% ----------------------------------------
% PSD:
% (I) d in R^N full: use auxd == chol(d);
% transposed mode : Y = Ud'\ X / Ud using Ud'*Ud = D
% ----------------------------------------
 if length(d) == length(x)
     for k = 1:K.rsdpN                            % REAL symmetric PSD
       nk = K.s(k); lastk = firstk + nk*nk - 1;
       Udk = mat(auxd(firstk-offud:lastk-offud),nk);
       Xk = mat(x(firstk:lastk),nk);
       Xk = Udk' \ (Xk / Udk);
       y(firstk:lastk) = Xk;
       firstk = lastk + 1;
     end
     for k = (K.rsdpN+1):length(K.s)              % COMPLEX Hermitian PSD
       nk = K.s(k); imfirstk = firstk + nk*nk; lastk = imfirstk + nk*nk -1;
       Udk = mat(auxd(firstk-offud:imfirstk-1-offud) ...
          + sqrt(-1) * auxd(imfirstk-offud:lastk-offud),nk);
       Xk = mat(x(firstk:imfirstk-1) + sqrt(-1) * x(imfirstk:lastk),nk);
       Xk = Udk' \ (Xk / Udk);
       y(firstk:lastk) = [real(Xk) imag(Xk)];
       firstk = lastk + 1;
     end
 else
% ----------------------------------------
% (II) d in R^n diagonal: Y = X ./ sqrt(d*d')
% ----------------------------------------
   for k = 1:K.rsdpN                            % REAL symmetric PSD
     nk = K.s(k); lastk = firstk + nk*nk - 1;
     dk = d(nextd:nextd+nk-1);
     Xk = mat(x(firstk:lastk),nk);
     Xk = Xk ./ sqrt(dk*dk');
     y(firstk:lastk) = Xk;
     firstk = lastk + 1; nextd = nextd + nk;
   end
   for k = (K.rsdpN+1):length(K.s)              % COMPLEX Hermitian PSD
     nk = K.s(k); lastk = firstk + 2*nk*nk - 1;
     dk = d(nextd:nextd+nk-1);
     dk = vec(sqrt(dk*dk'));
     y(firstk:lastk) = x(firstk:lastk) ./ [dk;dk];
     firstk = lastk + 1; nextd = nextd + nk;
   end
 end
