% Try to find small proportion of the cone primitives that appear
% in a large proportion of the primal constraints.

function dense = getdense(At,K,denq,denf)

 %  
 %   This file is part of SeDuMi 1.03BETA
 %   Copyright (C) 1999 Jos F. Sturm
 %   Dept. Quantitative Economics, Maastricht University, the Netherlands.
 %   Affiliations up to SeDuMi 1.02 (AUG1998):
 %     CRL, McMaster University, Canada.
 %     Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

 m = size(At,2);
 lorN = length(K.q);
% ----------------------------------------
% LP-part: find nnz-constraints for each column.
% ----------------------------------------
 if size(At,2) > 1
   colnz = full(sum(spones(At')))';
 else
   colnz = full(spones(At));             % only 1 constraint
 end
% ----------------------------------------
% LORENTZ/SDP part: find nnz-constraints for each block.
% ----------------------------------------
 blkstart = find(K.blkstart);
 Ablk = K.ABLK;                     % set LP part to all-0
 Ablk(1,:) = 0.0;
 if size(Ablk,2) > 1
   colnzqs = full(sum(spones(Ablk')))';
 else
   colnzqs = full(spones(Ablk));             % only 1 constraint
 end
 qlocs = blkstart(2:(lorN+1));
 colnz(qlocs) = colnzqs(2:(lorN+1));       %LORENTZ
 for i = (lorN+2):length(colnzqs)       % at all entries for PSD.
   colnz(blkstart(i):blkstart(i+1)-1) = colnzqs(i);
 end
% ----------------------------------------
% Find 75% quantile spquant. anything denser than 20*spquant is
% tagged as dense.
% ----------------------------------------
 ordnzs = sort(colnz);
 spquant = ordnzs(ceil(denq * length(colnz)));
 colnz = colnz(1:blkstart(2+lorN)-1);         % cannot remv SDP
 dense.cols = find(colnz > denf * spquant);           %dense LP-cols
 dense.qs = find(colnzqs(2:lorN+1) > denf * spquant);
 qlocs = qlocs(dense.qs);
 dense.qloc = zeros(1,length(dense.qs));
 for i = 1:length(dense.qs)
   dense.qloc(i) = find(dense.cols == qlocs(i));
 end
    %dense LORENTZ blks
% ----------------------------------------
% The number of dense columns should be small relative to
% the number of constraints - otherwise we better do 1 full Chol.
% ----------------------------------------
 if length(dense.cols) > size(At,2) / 2
   dense.qs = []; dense.cols = []; dense.qloc = [];
 end
