% FROMSDPA   Reads SDP problem from sparse SDPA-formatted input file.
%    [At,b,c,K] = fromsdpa(fname) produces conic optimization problem
%    data, as can be used by sedumi. "fname" contains a full pathname
%    to the SDPA 4.10-formatted file. (SDPA is a stand-alone solver for
%    semidefinite programming, by Fujisawa, Kojima and Nakata.  It is
%    used as a standard format in the collection SDPLIB by Borchers.)
%
%    To read and solve the problem "arch0", you may type
%
%    [At,b,c,K] = fromsdpa('arch0.dat-s');
%    [x,y,info] = sedumi(At,b,c,K);
%
%    The above 2 lines assume that arch0.dat-s is somewhere in your MATLAB
%    search path, that it is not compressed, and that you know the extension
%    'dat-s'.  To alleviate these conditions, you may like to use the script
%    GETPROBLEM.
%
% SEE ALSO SeDuMi, getproblem, frompack, prelp.

function [At,b,c,K] = fromsdpa(fname)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

fid = fopen(fname,'r');
if fid == -1
  error('File not found.')
end
m = fscanf(fid,'%d',1);
while(isempty(m))
  fgetl(fid); m = fscanf(fid,'%d',1);
end
sdpN = fscanf(fid,'%d',1);
K.s = fscanf(fid,'%d',sdpN);
K.s = abs(K.s);
b = fscanf(fid,'%f',m);
if(isempty(b))
  b1 = fscanf(fid,'{%f,',1);
  if(isempty(b1))
    error('Invalid sdpa file format\n')
  end
  b = [b1; fscanf(fid,'%f,',m-2); fscanf(fid,'%f}',1)];
end
if length(b) ~= m
   error('Invalid sdpa file format\n')
end
% ------------------------------------------------------------
% Get data in "ikrcf" format: A(constraint i, block k) has
%    entry "f" at position (r,c).
% ------------------------------------------------------------
E = fscanf(fid,'%d %d %d %d %f',[5. inf]);
% ------------------------------------------------------------
% Get c-vector. We've to change sign, because SDPA assumes "max"
% instead of "min".
% ------------------------------------------------------------
c = -sdpavec( E(2:5,find(E(1,:) == 0)),  K);
% ------------------------------------------------------------
% Construct each constraint i=1:m
% ------------------------------------------------------------
N = length(c);
At = sparse([],[],[],N,m,2*size(E,2));
for i = 1:m
  At(:,i) = sdpavec( E(2:5,find(E(1,:) == i)),  K);
end
fclose(fid);
