% ud = factorK(d,K)
% Computes ud = [sqrt(det(d(LORENTZ))); chol(d(SDP))]
% **********  INTERNAL FUNCTION OF SEDUMI **********

function ud = factorK(d,K)
% THE M-FILE VERSION OF THIS FUNCTION IS HERE ONLY AS ILLUSTRATION.
% SEE THE C-SOURCE FOR THE MEX-VERSION.

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

error('At OS prompt, type "make" to create SeDuMi mex-files.')

ud = zeros(length(K.q) + sum(K.s(1:K.rsdpN).^2) ...
  + 2*sum(K.s((1+K.rsdpN):length(K.s)).^2), 1);
% ----------------------------------------
% LORENTZ: ud = sqrt(det(d))
% ----------------------------------------
 firstk = K.l + 1;
 for k = 1:length(K.q)
   nk = K.q(k); lastk = firstk + nk-1;
   ud(k) = sqrt( qdet(d(firstk: lastk)) );
   firstk = lastk + 1;
 end
 offud = firstk - 1 - length(K.q);
% ----------------------------------------
% SDP: ud = chol(d)
% ----------------------------------------
 for k = 1:K.rsdpN
   nk = K.s(k); lastk = firstk + nk*nk -1;
   Dk = mat(d(firstk:lastk),nk);
   ud(firstk-offud : lastk-offud) = chol(Dk);
   firstk = lastk + 1; 
 end
 for k = (1+K.rsdpN):length(K.s)
   nk = K.s(k); ifirstk = firstk + nk*nk; lastk = ifirstk + nk*nk -1;
   Dk = mat(d(firstk:ifirstk-1) + sqrt(-1)*d(ifirstk:lastk),nk);
   Dk = chol((Dk+Dk')/2);
   ud(firstk-offud : ifirstk-1-offud) = real(Dk);
   ud(ifirstk-offud : lastk-offud) = imag(Dk);
   firstk = lastk + 1; 
 end

