% dpr1fact - Factor d[iag] p[lus] r[ank] 1:
% 
% [fi,d,deprows] = dpr1fact(p.*q, lab, find(lab==infty), tol, inf)
%    Computes fi and d such that
%       diag(lab) + p*q' =  L(p,q./fi) * diag(d) * L(q,p./fi)'
%    where L(p,beta) = eye(n) + tril(p*beta',-1).
%    
% find(fi==infty) is the subset of find(lab==infty) where the rows/columns
%    remain dependent.
%
% WARNING: the routine assumes that the pivot ordering 1,2,...,n is stable.
%   This is true e.g. if lab > 0 and p.*q >= 0.
%
function [fi,d,deprows] = dpr1fact(pq, lab, deprows, tol, inf)

% THE M-FILE VERSION OF THIS FUNCTION IS HERE ONLY AS ILLUSTRATION.
% SEE THE C-SOURCE FOR THE MEX-VERSION.

 %  
 %   This file is part of CholTool 1.00
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

error('At OS prompt, type "make" to create cholTool mex-files.')
