% x = sdpavec(E,K)
% Takes an SDPA type sparse data description E, i.e.
%   E(1,:) = block, E(2,:) = row, E(3,:) = column, E(4,:) = entry,
% and transforms it into a "long" vector, with vectorized matrices for
% each block stacked under each other. The size of each matrix block
% is given in the field K.s.
% **********  INTERNAL FUNCTION OF SEDUMI **********

function x = sdpavec(E,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

x = [];
for k = 1:length(K.s)
  nk = K.s(k);
  Ek = E(2:4,find(E(1,:) == k));
  Xk = sparse(Ek(1,:),Ek(2,:),Ek(3,:),nk,nk);
  Xk = Xk + triu(Xk,1)';
  x = [x; vec(Xk)];
end
