% pars = checkpars(pars,lponly)
% Fills in defaults for missing fields in "pars" structure.
% **********  INTERNAL FUNCTION OF SEDUMI **********
function pars = checkpars(pars,lponly)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

 if ~isfield(pars,'alg')
   pars.alg = -1;       %set to nonexistent alg, to be captured by next if:
 end
 if sum([0 1 2] == pars.alg) == 0
   if lponly
     pars.alg = 2;
   else
     pars.alg = 1;
   end
 end
 if ~isfield(pars,'beta')       % 0.1 <= beta <= 0.9 (theoretically in (0,1))
   pars.beta = 0.5;
 elseif pars.beta > 0.9
   pars.beta = 0.9;
 elseif pars.beta < 0.1
   pars.beta = 0.1;
 end
 if ~isfield(pars,'theta')      % 0.01 <= theta <= 1.0 (theoretically in (0,1])
   if pars.alg == 0
     pars.theta = 1;
   else
     pars.theta = 0.25;
   end
 elseif pars.theta > 1.0
   pars.theta = 1.0;
 elseif pars.theta < 0.01
   pars.theta = 0.01;
 end
 if ~isfield(pars,'fid')
   pars.fid = 1;
 end
 if ~isfield(pars,'eps')
   pars.eps = 1E-9;
 end
 if ~isfield(pars,'bigeps')                   % threshold for numerr=1 vs 2.
   pars.bigeps = 1E-3;
 end
 if ~isfield(pars,'maxiter')
   pars.maxiter = 150;
 end
 if ~isfield(pars,'vplot')
   pars.vplot = 0;
 end
%
 if ~isfield(pars,'innerQR')
   pars.innerQR = 1;
 end
 if ~isfield(pars,'stopat')
   pars.stopat = -1;
 end
 if ~isfield(pars,'numtol')
   pars.numtol = 5E-7;
 end
 if ~isfield(pars,'rimtol')
   pars.rimtol = 5E-10;
 end
 if ~isfield(pars,'sdreltol')
   pars.sdreltol = 0.01;
 end
 if isfield(pars,'chol')
   cholpars = pars.chol;
   if ~isfield(cholpars,'numlvl')
     cholpars.numlvl = 0;
   end
   if ~isfield(cholpars,'deptol')
     cholpars.reltol = 1e-25;
   end
   if ~isfield(cholpars,'ph1tol')
     cholpars.ph1tol = 1e-6;
   end
   if ~isfield(cholpars,'maxu')
     cholpars.maxu = 10;
   end
   if ~isfield(cholpars,'maxuden')
     cholpars.maxuden = 10;
   end
   if ~isfield(cholpars,'reltol')
     cholpars.reltol = 1e-12;
   end
 else
   cholpars.numlvl = 0;
   cholpars.deptol = 1e-25;
   cholpars.ph1tol = 1e-6;
   cholpars.maxu = 10;
   cholpars.maxuden = 10;
   cholpars.reltol = 1e-12;
 end
 pars.chol = cholpars;
