% L = blkchol(P,Lsymb,perm,xsuper,tmpsiz, ph1tol, reltol)
%   Computes sparse lower-triangular Cholesky factor L,
%            L*L' = P(perm,perm)
%   Parameters LSYMB, PERM, XSUPER and TMPSIZ
%   are typically generated by ORDMMDMEX.
%
%   There are important differences with standard CHOL(P(perm,perm))':
%
%   -  BLKCHOL uses the supernodal partition XSUPER, possibly splitted
%    by SPLIT, to use dense linear algebra on dense subblocks.
%    Much faster than CHOL.
%
%   -  BLKCHOL may adjust the pivot order of PERM, if numerical stability
%    is in danger. Namely, if a pivot drops below PH1TOL, then that node
%    is postponed until the end of the pivot-ordering.
%
%   -  BLKCHOL never fails. It only sees the lower triangular part of P;
%    if during the elimination, a diagonal entry drops below RELTOL*P(i,i),
%    that node i is flagged with the value -1, and discarded in
%    further computations.  This allows factorization of psd symmetric
%    systems with dependent rows.
%
% **********  INTERNAL FUNCTION OF CHOLTOOL  **********

function L = blkchol(P,Lsymb,perm,xsuper,tmpsiz, ph1tol, reltol)
 %  
 %   This file is part of CholTool 1.00
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

error('At OS prompt, type "make" to create cholTool mex-files.')



