/*
  BLKCHOL.H - header file for block sparse Cholesky with possible
  ADA-recomputing.
*/

#if !defined(BLKCHOL)
#define BLKCHOL
#include "blksdp.h"
#include <string.h>

/* ------------------------------------------------------------
   Type definitions:
   ------------------------------------------------------------ */

typedef struct{
  double ph1, dep, maxu;
} tolstruct;

typedef struct{
  const int *len;
  int *nodes;
  jcir u12;
  int n, maxnnz;
} ph2struct;

/* Structure used in cholp, to access data obtain by blkchol */
typedef struct{
  int m;
  const int *ljc, *lir, *u12jc, *u12ir;
  const double *lpr, *u12pr;
  const int *perm, *ph2nodes;
  int nsuper;
  const int *xsuper;
  double reltol, deptol;
} spcholstruct;

/* ------------------------------------------------------------
   PROTOTYPES:
   ------------------------------------------------------------ */
int blkLDL(const int neqns, const int nsuper, const int *xsuper,
           const int *snode,  const int *xlindx, const int *lindx,
           const int *ljc, double *lpr, const int *perm,
           const tolstruct tol, ph2struct *pph2,
           int iwsiz, int *iwork, int fwsiz, double *fwork);
int blkLDL0(const int neqns, const int nsuper, const int *xsuper,
            const int *snode,  const int *xlindx, const int *lindx,
            const int *ljc, double *lpr, const int *perm,
            const double deptol, int *depnodes,
            int iwsiz, int *iwork, int fwsiz, double *fwork);
void bwsolve(double *y, const int *Ljc, const int *Lir, const double *Lpr,
             const int *xsuper, const int nsuper);
void partbwsolve(double *y, const int *ljc, const double *lpr,
             const int *xlindx, const int *lindx, const int *xsuper,
             const int nsuper, const int m);
#endif
