% y = vectril(x,K)
% **********  INTERNAL FUNCTION OF SEDUMI **********

function y = vectril(x,K)

% THE M-FILE VERSION OF THIS FUNCTION IS HERE ONLY AS ILLUSTRATION.
% SEE THE C-SOURCE FOR THE MEX-VERSION.

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

error('At OS prompt, type "make" to create SeDuMi mex-files.')

 N = length(x);
 if issparse(x)
   y = sparse([],[],[],N,1,nnz(x));
 else
   y = zeros(N,1);
 end
% ----------------------------------------
% LP and LORENTZ: no symmetrization
% ----------------------------------------
 lastk = K.l + sum(K.q);
 y(1:lastk) = x(1:lastk);
 firstk = lastk + 1;
% ----------------------------------------
% PSD: Yk = (Xk+Xk')/2
% ----------------------------------------
for k = 1:length(K.s)
  nk = K.s(k); lastk = firstk + nk*nk - 1;
  Xk = mat(x(firstk:lastk),nk);
  y(firstk:lastk) = diag(diag(Xk))+ tril(Xk+Xk',-1);
  firstk = lastk + 1;
end
