% SPARFWSLV Solves block sparse upper-triangular system.
%    y = sparfwslv(L,b) yields the same result as
%              y = L.L\b(L.perm,:)
%    However, SPARFWSLV is faster than the built-in operator "\",
%    because it uses dense linear algebra and loop-unrolling on
%    supernodes.
%
%    For sparse b, one should use
%    y = sparfwslv(L,b,symbfwblk(L.L,L.xsuper, b));
%
%    Typical use, with X sparse m x m positive definite and b is m x n:
%            L = sparchol(symbchol(X),X);
%            L.d(L.dep) = inf;
%            y = sparbwslv(L,sparfwslv(L,b) ./ L.d);
%    Then y solves X*y=b.
%
% SEE ALSO symbchol, sparchol, sparbwslv, \, /.

function y = sparfwslv(L,b, ysymb)
% ----------------------------------------
% Solve L.L * y = b
% ----------------------------------------
 if nargin > 2
   y = fwblkslv(L,b,ysymb);
 else
   y = fwblkslv(L,b);
 end
% ----------------------------------------
% Solve for Phase II nodes:
% U12'*y + U22' * y2 = y2OLD
% ----------------------------------------
 b2 = full(y(L.ph2nodes,:) - L.U12'*y);
 y(L.ph2nodes,:) = fwslvp(L.U22,L.ph2perm,b2);
