% [A,c,K,L,d,ud, v,vfrm,x,y,y0, R] = sdinit(At,b,c,K,pars)
% Initialize with identity solution, for self-dual model.
% **********  INTERNAL FUNCTION OF SEDUMI **********
function [A,c,K,L,d,ud, v,vfrm,x,y,y0, R] = sdinit(At,b,c,K,pars)

 %  
 %   This file is part of SeDuMi 1.03BETA
 %   Copyright (C) 1999 Jos F. Sturm
 %   Dept. Quantitative Economics, Maastricht University, the Netherlands.
 %   Affiliations up to SeDuMi 1.02 (AUG1998):
 %     CRL, McMaster University, Canada.
 %     Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

 m = length(b);
% --------------------------------------------------
% Check the pars that we need
% --------------------------------------------------
 if ~isfield(pars,'denq')
   pars.denq = 0.75;
 end
 if ~isfield(pars,'denf')
   pars.denf=10;
 end
% ----------------------------------------
% Create artificial (x0,z0) variable for
% self-dual model
% ----------------------------------------
 c = [0;c];            %does not affect sparse/dense status of c.
 At = [sparse(1,m); At];
 K.l = K.l + 1;    % add (x0,z)
% ----------------------------------------
% Make more detailed description of cone K:
% Let K.blkstart such that [position k-th nonzero]
%     = [start of k-th block in c,x,z and At(:,i) vectors]
% and position last nonzero = length(c)+1;
% Let n = order(K).
% ----------------------------------------
 if isempty(K.q)
   qcum = []; qDim = 0; K.qMaxn = 0;
 else
   qcum = cumsum(K.q); qDim = qcum(length(qcum));
   K.qMaxn = max(K.q);
 end
 if K.rsdpN == 0
   rcum = []; rDim = 0; K.rMaxn = 0; K.rLen = 0;
 else
   rcum = cumsum(K.s(1:K.rsdpN).^2);
   rDim = rcum(K.rsdpN);
   K.rMaxn = max(K.s(1:K.rsdpN));
   K.rLen = sum(K.s(1:K.rsdpN));
 end
 if length(K.s) == K.rsdpN
   hcum = []; hcol = []; K.hMaxn = 0; K.hLen = 0;
 else
   hcum = cumsum(2 * K.s(K.rsdpN+1:length(K.s)).^2);
   hcol = cumsum(2 * K.s(K.rsdpN+1:length(K.s)));
   K.hMaxn = max(K.s(K.rsdpN+1:length(K.s)));
   K.hLen = hcol(length(hcol)) / 2;
 end
 K.blkstart = sparse([1 1+K.l 1+K.l+qcum 1+K.l+qDim+rcum ...
    1+K.l+qDim+rDim+hcum],1,1);
 n = K.l + 2 * length(K.q) + K.rLen + K.hLen;
% ------------------------------------------------------------
%  Make sure that the PSD blocks of c are symmetric/ Hermitian
% ------------------------------------------------------------
 if issparse(c)
   c = sparse(vecsym(full(c),K));
 else
   c = vecsym(c,K);
 end
% ----------------------------------------
% y = 0;  d=z=x = identity.
% ud.qdet = [sqrt(det(d(LORENTZ))), ud.u = chol(d(SDP)).
% ----------------------------------------
 y = zeros(m,1);
 x = eyeK(K);
 d = x;
 [ud.qdet, ud.u, ispos, ud.perm] = factorK(d,K);
 v = x;
% ----------------------------------------
% Create Jordan frame of v: (arbitrary, since we have unit solution)
% vfrm.s = I in Householder product form,
% vfrm.q = e1/sqrt(2)
% Denotes Lorentz frame [1/sqrt(2), 1/sqrt(2); -vfrm.q, vfrm.q].
% ----------------------------------------
 vfrm.lab = ones(n,1);
 vfrm.s = qrK(ud.u,K);
 if isempty(K.q)
   vfrm.q = [];
 else
   vfrm.q = zeros(qDim - length(K.q),1);
   vfrm.q(1) = 1/sqrt(2);
   numqm1 = length(K.q) - 1;
   vfrm.q(1+qcum(1:numqm1)-(1:numqm1)) = 1/sqrt(2);
 end;
% ----------------------------------------
% Residuals R.b, R.c, R.sd, and size-parameter R.b0.
%         A x - x0 b - y0 R.b      = 0
%  -A'y       + x0 c + y0 R.c - z  = 0
%   b'y - c'x        + y0 R.sd - z0 = 0
% ----------------------------------------
 R.b0 = 1; y0 = n;
 R.b = (At'*x-b)/y0;
 R.c = (x-c)/y0;             % x means "z", but is the same
 R.c(1) = 0.0;               % for artificial (x0,z0)
 R.sd = (x(1) + c'*x)/y0;
% ----------------------------------------
% Symbolic analysis:
%  1. find block pattern "ABLK" of At
%  3. find (relatively) dense columns
%  4. symbolic form of A*D*At, after removing dense columns
%  5. ordering and symbolic factorization of this form (SYMBADA).
% ----------------------------------------
 K.ABLK = indexa(At,K);
 dense = getdense(At, K, pars.denq,pars.denf);
 if length(dense.cols) > 0
   A.den = At(dense.cols,:)';
 else
   A.den = sparse(m,0);         % patch bug in MATLAB 5.0
 end
 A.t = At;                   % remove dense columns and blocks.
 if length(dense.qs) > 0
   A.blkq = K.ABLK(1+dense.qs,:)';      %All rows involving dense q-blocks.
 else
   A.blkq = sparse(m,0);    % patch bug in MATLAB 5.0
 end
 if length(dense.cols) > 0
   A.t(dense.cols,:) = 0.0;
   K.ABLK = indexa(A.t,K);           % Block structure of sparse part
 end
 A.dense = dense;
% ----------------------------------------
%  find nonzero pattern "DZSTRUCT" of At*dy in PSD part,
% and order constraints from sparse (in PSD) to dense.
% ----------------------------------------
 [K.DZSTRUCT,A.perm] = dzstruct(A.t,K);
% ----------------------------------------
% Get nz-pattern of ADA.
% ----------------------------------------
 K.SYMBADA = getsymbada(A.t,K,dense.qs,A.perm);
 L = symbchol(K.SYMBADA);
 L.fullperm = A.perm(L.perm);
% --------------------------------------------------
% Symbolic fwsolve LA_den = L\Aden,
% sparse ordering for dense column factorization
% --------------------------------------------------
 Lden.LAD = [A.den, A.blkq];
 if isempty(Lden.LAD)
   Lden.LAD = sparse(m,0);    % patch bug in MATLAB 5.0
 else
   Lden.LAD = symbfwblk(L.L,L.xsuper, Lden.LAD(L.fullperm,:));
 end
 [Lden.rowperm0, Lden.colperm, Lden.xsuper0] = dpr1order(Lden.LAD,dense.qloc);
 L.den = Lden;
