% [dy0, deltax0] = sddirslv(L,Lsd, rhs,rhs0, y,pars)
%

% J.F. Sturm, 1999.

function [dy, deltax0] = sddirslv(L,Lsd, rhs,rhs0, y,pars)
% --------------------------------------------------
% Solve:
%   [diag(lab), p; q', p0] * [dy;dx0] = [rhs; rhs0]
% --------------------------------------------------
 if pars.innerQR == 1
   dy = doinfw(Lsd,rhs0,rhs,L.dep);
   [deltax0, dy] = doinbw(Lsd, dy, L.dep);
 else
   L.d(L.dep) = inf;
   deltax0 = (rhs0 - Lsd.q' * rhs) / Lsd.p0;
   dy = (rhs - deltax0 * Lsd.p) ./L.d;
 end
% --------------------------------------------------
% BACKWARD STEP in computing dy,  L' * dyNEW = dyOLD
% --------------------------------------------------
 dy = sparbwslv(L,bwdpr1(L.den, dy));
 dy = dy + (Lsd.alpha*deltax0) * y;
