% [dx, dy, dz, dy0, deltaz] = sddir(L,Lsd,p, Rscl, ...
%         d,ud,v,vfrm,A,c,R, K,pars,y,y0,b)
% **********  INTERNAL FUNCTION OF SEDUMI **********

function [dx, dy, dz, dy0, deltaz] = sddir(L,Lsd,p, Rscl, ...
          d,ud,v,vfrm,A,c,R, K,pars,y,y0,b)
 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

% ------------------------------------------------
% dy0 = v'*p,    cDp = c'*D(d)*p,    ADp = A*D(d)*p
% ------------------------------------------------
 x0 = d(1)*v(1);
 if isempty(p)          % p = [] means affine scaling (so p = -v)
   p0  = -v(1);
   dy0 = -y0;
   cDp = -Rscl.cx;                              % D*v = x, so cDp = -cx.
   RcDp = -Rscl.Rcx;
   ADp = -(x0*b + y0*R.b);                 % A*D*v = A*x = x0*b+y0*Rb
 else
   p0 = p(1);
   if length(p) == length(vfrm.lab)        % spectral values w.r.t. vfrm
     dy0 = (vfrm.lab'*p) / R.b0;
     p = frameit(p,vfrm.q,vfrm.s,K);       % Let p = VFRM * p.
   else
     dy0 = (v'*p) / R.b0;
   end
   Dp  = scaleK(d,ud,p,K,1);
   cDp = c'*Dp;
   RcDp = R.c'*Dp;
   ADp = Amul(A,Dp,0);
 end
% --------------------------------------------------
% COMPUTE (rhs,rhs0), preconditioned by Cholesky L-factor:
% Solve    L*rhs   =   dy0 * (Rb + ADRc) - ADp
% rhs0 = dy0 * |DRc|^2 - p'*DRc
% -------------------------------------------------- '
 rhs = fwdpr1(L.den ,sparfwslv(L, dy0 * Rscl.b - ADp));
 rhs0 = dy0 * Rscl.b0 + Lsd.beta*y0*RcDp -(1-Lsd.beta*x0)*(p0/d(1)+cDp);
% --------------------------------------------------
% Solve:
%   [LAB, p; q', p0] * [dy;dx0] = [rhs; rhs0]
% --------------------------------------------------'
 [dy, deltax0] = sddirslv(L,Lsd, rhs,rhs0, y,pars);
% --------------------------------------------------
% We compute dz from the identity "y0*Rc = A'*y+z-x0*c"
% --------------------------------------------------
 deltaz = vecsym(dy0*R.c - Amul(A,dy,1) + deltax0*c, K);
 dz = scaleK(d,ud,deltaz,K);                 % dz = D(d)*deltaz
% --------------------------------------------------
% We get dx from "dx + dz = p"
% --------------------------------------------------
 if isempty(p)
   dx = -(v+dz);
 else
   dx = p-dz;
 end
 dx(1) = deltax0 / d(1);
 dz(1) = p0 - dx(1);
 deltaz(1) = dz(1) / d(1);
