% y = scaleK(d,x,K,ud,transp,df,frame)
% Computes y = D(d)*x with d in int(K).
% Uses ud = factorK(d,K).
% Arguments "df, frame" only needed if x is in spectral space.
% **********  INTERNAL FUNCTION OF SEDUMI **********

function y = scaleK(d,x,K,ud,transp, df,frame)

% THE M-FILE VERSION OF THIS FUNCTION IS HERE ONLY AS ILLUSTRATION.
% SEE THE C-SOURCE FOR THE MEX-VERSION.

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

error('At OS prompt, type "make" to create SeDuMi mex-files.')

 y = zeros(length(d),1);
 if nargin < 5
   transp = 0;
 end
% ----------------------------------------
% LP: y = d .* x
% ----------------------------------------
 if K.l > 0
   y(1:K.l) = d(1:K.l) .* x(1:K.l);
 end
 firstk = K.l+1;
% ----------------------------------------
% LORENTZ: y = d scale x
% (I) x in R^N full: using ud=sqrt(detd)
% ----------------------------------------
 if length(x) == length(d)
   for k = 1:length(K.q)
     nk = K.q(k); lastk = firstk + nk - 1;
     y(firstk:lastk) = qlmul(d(firstk:lastk),x(firstk:lastk),ud(k));
     firstk = lastk + 1;
   end
 else
% ----------------------------------------
% (II) x in R^n spectral: using ud = sqrt(detd), df = d'*f
% ----------------------------------------
   nextx = K.l + 1;
   nextf = 1;
   for k = 1:length(K.q)
     nk = K.q(k); lastk = firstk + nk - 1;
     y(firstk:lastk) = qlmul( d(firstk:lastk),x(nextx:nextx + 1),...
	ud(k), df(k), frame(nextf:nextf+nk-2));
%       xk = qtofull(frame(nextf:nextf+nk-2),x(nextx:nextx + 1));
%      y(firstk:lastk) = qlmul(d(firstk:lastk),xk,ud(k));
     nextx = nextx + 2; nextf = nextf + nk - 1; firstk = lastk + 1;
   end
 end
 offud = firstk - 1 - length(K.q);    % next is ud(firstk - offud)
% ----------------------------------------
% SDP: Y = Ud * X * Ud' using Ud'*Ud = D
% ----------------------------------------
 if ~transp
   for k = 1:length(K.s)
     nk = K.s(k); lastk = firstk + nk*nk - 1;
     Udk = mat(ud(firstk-offud:lastk-offud),nk);
     Xk = mat(x(firstk:lastk),nk);
     Xk = Udk * Xk * Udk';
     y(firstk:lastk) = Xk;
     firstk = lastk + 1;
   end
 elseif length(x) == length(d)
% ----------------------------------------
% (II) transp == 1 then Y = Ud' * X * Ud
% ----------------------------------------
   for k = 1:length(K.s)
     nk = K.s(k); lastk = firstk + nk*nk - 1;
     Udk = mat(ud(firstk-offud:lastk-offud),nk);
     Xk = mat(x(firstk:lastk),nk);
     Xk = Udk' * Xk * Udk;
     y(firstk:lastk) = Xk;
     firstk = lastk + 1;
   end
 else
% ----------------------------------------
% (III) transp==1 and x in spectral space:
%  Y = Ud' * diag(x) * Ud
% ----------------------------------------
   for k = 1:length(K.s)
     nk = K.s(k); lastk = firstk + nk*nk - 1;
     Udk = mat(ud(firstk-offud:lastk-offud),nk);
     Xk = Udk' * sparse(1:nk,1:nk,x(nextx:nextx+nk-1)) * Udk;
     y(firstk:lastk) = Xk;
     nextx = nextx + nk; firstk = lastk + 1;
   end
 end
