% [dx,dy,dz,deltax,deltaz,Lsd,erb,failure] = refine(dyIN,deltazIN,dy0,...
%          dxIN, dzIN, d,ud, A,b,c,K,L,Lsd,R,y,pars, x0,y0)
function [dx,dy,dz,deltax,deltaz,Lsd,Rscl,erb,failure] = refine(dyIN,deltazIN,dy0,...
          dxIN, dzIN, d,ud, A,b,c,K,L,Lsd,R,y,pars, x0,y0,v,by,Rscl)

% ------------------------------------------------------------
% Let deltax = D(d)*dx
% ------------------------------------------------------------
 deltaxIN = scaleK(d,ud, dxIN,K,1);
% --------------------------------------------------
% Compute residual vector (input to refinement):
% Let dRb = A*deltax - (deltax0 * b + dy0 * Rb)
%     db0 = Rc'*deltax - Rb'*dy + R0*deltax0
% --------------------------------------------------
 dRb = Amul(A,deltaxIN,0) - (deltaxIN(1) * b + dy0 * R.b);
 erbIN = norm(dRb);
 db0 = R.c'*deltaxIN - R.b'*dyIN + R.sd*deltaxIN(1);
 dRsdy0 = c'*deltaxIN - b'*dyIN + deltazIN(1) - dy0*R.sd;
 errs = [abs(dxIN'*dzIN) , erbIN , abs(dRsdy0)];
 maxerr=max(errs);
 if maxerr > pars.numtol * y0 * (1+R.norm)
% --------------------------------------------------
% FORWARD STEP in computing dy:
% Solve    L*dy   =   -dRb
% rhs0 = (beta*y0)* db0 - (1-beta*x0)*dRsdy0
% --------------------------------------------------
   rhs = fwdpr1(L.den ,sparfwslv(L, -dRb));
   rhs0 = (Lsd.beta*y0)*db0 - (1-Lsd.beta*x0)*dRsdy0;
% --------------------------------------------------
% Solve:
%   [LAB, p; q', p0] * [dy;dx0] = [rhs; rhs0]
% --------------------------------------------------
   [dy, deltax0] = sddirslv(L,Lsd, rhs,rhs0, y,pars);
% --------------------------------------------------
% We compute dz from the identity "A'*dy+dz-dx0*c = 0"
% --------------------------------------------------
   deltaz = vecsym(deltax0*c - Amul(A,dy,1) , K);
% --------------------------------------------------
% We get dx from "dx + dz = 0" -->  deltax = -D(d^2)deltaz
% --------------------------------------------------
   dz = scaleK(d, ud, deltaz, K);          % dz=D(d)*deltaz
   dz(1) = -deltax0 / d(1);
   deltaz(1) = dz(1) / d(1);
   dx = dxIN-dz;                            % add dx=-dz to dxIN.
   deltax = scaleK(d, ud, dx, K, 1);        % deltax=D(d)dx
   dy = dyIN + dy;
   deltaz = deltazIN + deltaz;              % add deltaz to deltazIN
   dz = dzIN + dz;
% ------------------------------------------------------------
% Evaluate quality of refined direction
% ------------------------------------------------------------
   erb = norm(Amul(A,deltax,0) - deltax(1)*b - dy0*R.b);
   dRsdy0 = c'*deltax - b'*dy + deltaz(1) - dy0*R.sd;
   errs2 = [abs(dx'*dz) , erb , abs(dRsdy0)];
   keepold = (max(errs2) >= max(errs));
 else
   keepold = 1;           % force keeping old.
 end
 if keepold               % reject refined step
   dx = dxIN; dy = dyIN; dz = dzIN;        % keep old step
   deltax = deltaxIN; deltaz = deltazIN;
   erb = erbIN;
   failure = (max(errs(1), errs(2)/(1+R.norm)) > 0.9 * y0);
 else
   failure = (max(errs2(1), errs2(2)/(1+R.norm)) > 0.9 * y0);
 end
