function  [d,ud,vfrm] = newtransfo(x,ux,z,w, dIN,udIN,K)

% ------------------------------------------------------------
% Given w = D(Xscl)Zscl, compute spec-factor Q*WLAB*Q' = W (')
% For LP/LORENTZ we only need spectral values VLAB = sqrt(WLAB).
% ------------------------------------------------------------
 [wlab,q] = eigK(w,K);
 vfrm.lab = sqrt(wlab);
% ------------------------------------------------------------
% LP: d = dIN .* (x ./ vlab)
% ------------------------------------------------------------
 dLP = dIN(1:K.l) .* x(1:K.l) ./ vfrm.lab(1:K.l);
% ------------------------------------------------------------
% LORENTZ: vinv = w^{-1/2}, detv = det(w^{1/2}).
% ------------------------------------------------------------
 il = K.l + 2*(1:length(K.q));                  %locations of 2nd eigenvalues
 detv = vfrm.lab(il-1) .* vfrm.lab(il);         %vlab1 * vlab2
 vinv = qinvsqrt(w,detv,K);
% ------------------------------------------------------------
% Now dscl = D(xscl) vinv = xscl # zscl^{-1}, metric-geometric mean.
% ------------------------------------------------------------
 dscl = qscaleK(x,ux.qdet,vinv,K);
% ------------------------------------------------------------
% Compute Lorentz frame of v, the spectral-geometric mean of x and z.
% Also let dq = D(dIN) * dscl.
% ------------------------------------------------------------
 [vfrm.q,dq,ud.qdet] = qframev(x,ux.qdet,dIN,udIN.qdet,dscl,vfrm.lab,...
     sqrt(detv),K);
 d = [dLP; dq];
% ------------------------------------------------------------
% PSD: D= QUD'*QUD, where QUD(:,udIN.perm) = diag(1./sqrt(vlab))*Q'*ux*ud.
% Let vinv = diag(1./sqrt(vlab))*Q'.
% ------------------------------------------------------------'
 ud.u = triumtriu(ux.u, udIN.u, K);             % ux * ud
 [ud.u,ud.perm,gjc,g] = urotorder(ud.u,K, 1.1, udIN.perm);  % stable reordering
 q = givensrot(gjc,g,q,K);    % ROTATE Q accordingly: (G*Q)'*(G*ux*ud).'
 vinv = sinv(q,vfrm.lab,K);
% ------------------------------------------------------------
% QR-FACTORIZE: Qv * VINV = R
% Then the new ud is simply R*ux*ud, which is upper triangular.
% ------------------------------------------------------------
 [vfrm.s, r] = qrK(vinv,K);
 ud.u = triumtriu(r, ud.u, K);
% ------------------------------------------------------------
% Optional: reorder to stable U-factor by Givens rotations.
% i.e ud.uNEW = G*ud.uOLD(:,perm),
%     QvNEW = G*QvOLD.
% ------------------------------------------------------------

%****** ALTERNATIVE ********
% vinv = sinv(q,vfrm.lab,K);
% [vfrm.s, r] = qrK(vinv,K);
% ud.u = triumtriu(triumtriu(r,ux.u,K), udIN.u, K);
% [ud.u,ud.perm,gjc,g] = urotorder(ud.u,K, 2, udIN.perm);  % stable reordering
% vfrm.s = givensrot(gjc,g,vfrm.s,K);    % ROTATE a H.H.-Reflection-product.
% **************************
