% t = maxstep(dx,dz, xc,auxxc,zc,auxzc,K)
% Computes maximal step length to the boundary of the cone K.
% **********  INTERNAL FUNCTION OF SEDUMI **********

function t = maxstep(dx,dz, xc,auxxc,zc,auxzc,K)
 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

reldx = invscaleK(xc,auxxc, dx,K,1);
reldz = invscaleK(zc,auxzc, dz,K,1);
mindx = min(eigK(reldx, K));
mindz = min(eigK(reldz, K));
t = 1 / max([-mindx,-mindz,1E-16]);
