% [At,b,ycomplex] = makeyreal(At,b,c,K)
% **********  INTERNAL FUNCTION OF SEDUMI **********
function [At,b,ycomplex] = makeyreal(At,b,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %


 if ~isempty(K.ycomplex) | ~isreal(b)
% ----------------------------------------
% Make "imag(Ax) = imag(b)" and "imag(y)" explicit, where desired.
% ----------------------------------------
  ycpx = zeros(length(b),1);
  ycpx(K.ycomplex) = 1;
  ycpxAuto = (imag(b) ~= 0); ycpxAuto(K.ycomplex) = 0;
  ycpxAuto = find(ycpxAuto);
  ycpx(ycpxAuto) = 1;
% Give a warning for small imag(b(ycpxAuto))
  if any(abs(imag(b(ycpxAuto))) < 5e-9)
    warning('Implicit complex y(i) created with 0 < |imag(b(i))| < 5e-9.')
  end
           % filter out components where complex y doesn't make sense anywhere:
   ycpx = find(ycpx);
   iota = (eyeK(K) ~= 0);
   K.ycomplex = ycpx(max(abs(At(iota==0,ycpx))) > 0);
   if ~isempty(K.ycomplex)
     imb = imag(b(K.ycomplex));
     imAt = sqrt(-1) * At(:,K.ycomplex);
     imAt(find(iota),:) = 0;    % remove real-only part for imag(y) variables
     At = [At, imAt];
     b = [real(b); -imb];
   end
 end
% ----------------------------------------
% Return ycomplex
% ----------------------------------------
 ycomplex = K.ycomplex;
