% [At,c,K,cpx] = makereal(At,c,K)
% **********  INTERNAL FUNCTION OF SEDUMI **********
function [At,c,K,cpx] = makereal(At,c,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %


if isreal(At) & isreal(c)
  cpx.q = []; cpx.s = []; cpx.dim = 0;
else
  iota = (eyeK(K) ~= 0);
  if(~isreal(At(iota,:)))
    error('A matrix has imaginary data in real-only components.')
  end
  if(~isreal(c(iota)))
    error('c has imaginary data in real-only components.')
  end
% ----------------------------------------
% Identify the Lorentz and PSD blocks where complex data is involved
% ----------------------------------------
  cpx = complexblk(full(c) + full(At*rand(size(At,2),1)),K);
  if cpx.dim > 0
% ----------------------------------------
% Put complex At and c in MATLAB's real (but higher dimensional) format
% ----------------------------------------
    Atpr = real(At); Atpi = imag(At);
    cpr = real(c); cpi = imag(c);
    N = size(At,1) + cpx.dim;
    At = sparse([],[],[],N,size(At,2),nnz(Atpr) + nnz(Atpi));
    c = vecreal(cpr,cpi,cpx,K);
    for i = 1:size(At,2)
      At(:,i) = vecreal(Atpr(:,i),Atpi(:,i),cpx,K);
    end
% ----------------------------------------
% Update K: -dimension of Lorentz variables has increased
%           -PSD variables have been permuted (to put real symmetric first)
% ----------------------------------------
    K.q(cpx.q) = 2 * K.q(cpx.q) -1;   % real size of complex Lorentz variables
    sperm = ones(length(K.s),1);
    sperm(cpx.s) = 0;
    sperm = [find(sperm); cpx.s];
    K.s = K.s(sperm);
  end
end

