% [failure,x,y] = final(d,ud,A,b,c, y0,yIN,xIN,z0,dxmdz, K,L,feasratio,...
%      Rb,numerr,cholflag,lponly)
% numerr is a flag: 1 iff stopped due to numerical errors.
% failure = (-1: succesful basis identification, 0: not tried, 1: failure)
% **********  INTERNAL FUNCTION OF SEDUMI **********

function [failure,x,y] = final(d,ud,A,b,c, y0,yIN,xIN,z0,dxmdz, K,L,...
         feasratio, Rb,numerr,cholflag,lponly)
 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %


% ------------------------------------------------------------
% feasratio < -0.9       ===> infeasible, project onto direction space
% |feasratio| < 0.9      ===> we're not sure, keep solution
% numerr == 1            ===> idem
% feasratio > 0.9        ===> feasible, project onto solution space
% ------------------------------------------------------------
 failure = 0;
 x = xIN; y = yIN;
 x0 = x(1);
 if (feasratio < 0.0) & (x0 < z0*z0)
   x0 = 0;
 end
% ------------------------------------------------------------
% For LP-problems, we PROJECT onto OPTIMAL FACE
% ------------------------------------------------------------
 if lponly & ( abs(abs(feasratio)-1) < 0.1 ) & (numerr == 0)
% ------------------------------------------------------------
% Set d(Non-basic-LP) = 0
% Nonbasic is where dx < dz i.e. dxmdz < 0, ideally: dx_N = -v_N, dz_N = 0.
% ------------------------------------------------------------
   if K.l > 1
     failure = -1;                    % means we're going to guess
     lpNB = 1+find(dxmdz(2:K.l) < 0);
     d(lpNB) = 0;
     x(lpNB) = 0;
   end
% ------------------------------------------------------------
% rhs = x0 * b - A*x
% ------------------------------------------------------------
   rhs = x0 * b - Amul(A,x,0);
% ----------------------------------------
% Solve ADA*rhs_new = rhs.
% ----------------------------------------
   dsqr = d(1:K.l).^2;
   detd = ud.qdet.^2;
   udsqr = invcholfac(ud.u,K, ud.perm);
   [ADA,ddota] = getada(A,d,dsqr,detd,udsqr,K);
   if isempty(ddota) | isempty(A.dense.qs)
     m = size(ADA,1);
     ddota = sparse(m,0);    % patch bug in MATLAB 5.0
   else
     ddota(:,A.perm) = ddota;
     ddota = ddota(A.dense.qs,:)';
   end
   L = sparchol(L,ADA,cholflag, ddota,A,d,ud,K);
   L.d(L.dep) = inf;
   rhs = fwdpr1(L.den,sparfwslv(L,rhs))./L.d;
   rhs = sparbwslv(L,bwdpr1(L.den,rhs));
% ------------------------------------------------------------
%  x^* = (x + D(d^2) * At * rhs) / ( (x0==0) + x0)
% ------------------------------------------------------------
   dx = vecsym(full(Amul(A,rhs,1)),K);
   dx = scaleK(d, ud, dx, K);              % D(d)   * (At*rhs)
   dx = scaleK(d, ud, dx, K, 1);           % D(d)^2 * (At*rhs)
   x = x + dx;
% ----------------------------------------
% CHECK WHETHER X[BASIC] >= 0 AND WHETHER RESIDUAL IMPROVED (LP ONLY)
% ----------------------------------------
   if K.l > 1
     if  (min(x(1:K.l-1)) < 0.0) | ...
          (norm(Amul(A,x,0)-x0*b) > max(1E-10 * x0, y0 * norm(Rb)))
       failure = 1;  % Incorrect guess of LP-basis
     end
     if failure ~= 1
% ==================== DUAL PART (LP ONLY) ====================
% ------------------------------------------------------------
% Solve A_LPBASIS'*dy = (x0*c-At*y)_LPBASIS.
% Let rhs = A*D_LPBASIS*(x0*c - At*y)
% ------------------------------------------------------------
       rhs = Amul(A,y,1);                  % recall that d_lpNB == 0
       rhs = dsqr(1:K.l) .* (x0*c(1:K.l) - rhs(1:K.l));
       rhs = Amul(A,[rhs;zeros(length(x)-K.l,1)],0);
% ------------------------------------------------------------
% Solve ADA*rhs = rhs.
% ------------------------------------------------------------
       rhs = fwdpr1(L.den,sparfwslv(L,rhs))./L.d;
       rhs = sparbwslv(L,bwdpr1(L.den,rhs));
% ------------------------------------------------------------
% Let y = (y + rhs)
% ------------------------------------------------------------
       y= y+rhs;
% ------------------------------------------------------------
% CHECK WHETHER Z[BASIC] >= 0
% ------------------------------------------------------------
       zLP = Amul(A,y,1); 
       zLP = x0*c(1:K.l) - zLP(1:K.l);
       if (min(zLP(lpNB)) < 0.0) | (min(zLP) < -(1E-8) * x0)
         failure = 1;  % Incorrect guess of LP-basis
       end
     end
   end
% ------------------------------------------------------------
% If we did an optimality projection for infeasible LPs, we've
% to check whether cx and by are still the same sign.'
% ------------------------------------------------------------
   if (failure == -1)
     cx = c'*x; by = b'*y;
     if (x0 == 0)
       if cx - by >  - 1E-5
          failure = 1;     % Changed improving direction into nothing.
       end
     else
       if abs(cx - by) > 1E-5 * (abs(cx) + 1E-4)
         failure = 1;
       end
     end
   end
% ------------------------------------------------------------
% In case of a failure, restore old x and y
% ------------------------------------------------------------
   if failure == 1
     x = xIN; y = yIN;
   end
 end
% ------------------------------------------------------------
% In any case, let (x,y) = (x,y) / ((x0==0)+x0)
% ------------------------------------------------------------
 y = y/((x0==0) + x0);
 x = x(2:length(x)) / ( (x0==0) + x0);
