% [L,Lsd,Rscl] = factorneq(L,d,ud,A,b,c,K,R, y0,v,by,pars)
% Factor normal equation system
%

function [L,Lsd,Rscl] = factorneq(L,d,ud,A,b,c,K,R, y0,v,by,pars)

% ------------------------------------------------------------
% COMPUTE AND FACTOR
% ADA_ij = (D(d^2) a_i)' * a_j
% ------------------------------------------------------------
 x0 = v(1) * d(1);
 dsqr = d(1:K.l).^2;
 detd = ud.qdet.^2;
 udsqr = invcholfac(ud.u,K, ud.perm);
 [ADA,ddota] = getada(A,d,dsqr,detd,udsqr,K);
 if isempty(ddota) | isempty(A.dense.qs)
   m = size(ADA,1);
   ddota = sparse(m,0);    % patch bug in MATLAB 5.0
 else
   ddota(:,A.perm) = ddota;
   ddota = ddota(A.dense.qs,:)';
 end
 L   = sparchol(L,ADA,pars.chol, ddota,A,d,ud,K);
% ------------------------------------------------------------
% Compute  D(d^2)Rc
% ------------------------------------------------------------
 DRc = scaleK(d, ud, R.c, K);
 Rcx = DRc'*v;
 ssqrDRc = norm(DRc)^2;
 DRc = scaleK(d, ud, DRc, K, 1);
 ADRc = Amul(A,DRc,0);
% ------------------------------------------------------------
% Build system [diag(L.d), p; q', p0] * [dy0;dx0] for self-dual model.
% q = L\(A*DRc-Rb),  Lb = L\b,  p = (y0/x0)*q - 2*Lb, and
% p0*x0 = b0 + y0*|DRc|^2 - 2*Rcx
% ------------------------------------------------------------
 q  = fwdpr1(L.den, sparfwslv(L,ADRc - R.b));
 Lb = fwdpr1(L.den, sparfwslv(L,full(b)));
 p  = (y0/x0) * q - 2*Lb;
 p0 = (R.b0 + y0 * ssqrDRc - 2 * Rcx) / x0;
% ------------------------------------------------------------
% Check whether this system can be factorized reliably, viz.
% dp0 and p0+dp0 should be of the same order as p0, where dp0=q'*(p./lab)
% ------------------------------------------------------------
 lab = L.d; 
 lab(L.dep) = inf;
 dp0 = q'*(p./lab);
 if (p0*dp0 < -0.1*p0*p0) & (pars.chol.numlvl > 0)
% ------------------------------------------------------------
% Recondition the system, using the relation
% ADA*y = x0*(AD(d^2)c-b) + y0*(ADRc-Rb).
% Let LLy = L\ADAy = x0*q2 + y0 * q,  and Ly = LLy./L.d = L'*y.
% ------------------------------------------------------------
   Dc = scaleK(d, ud, full(c), K);
   Rscl.cx = Dc'*v;
   ssqrDc = norm(Dc)^2;
   Dc = scaleK(d, ud, Dc, K, 1);
   q2 = fwdpr1(L.den, sparfwslv(L, Amul(A,Dc,0) - b));   % q2=L\(ADc-b)
   LLy = x0*q2 + y0*q;
   Ly = LLy ./ lab;
   ssqrLy = Ly'*LLy;              % |sqrt(L.d).*Ly|
   if ssqrLy > 1e-16              % in iter 0, we've y = 0.
% ------------------------------------------------------------
% Let p2 = L\(b+ADc) = q2+2*Lb.
% Let alpha = arg min |(alpha*LLy-p2) ./ sqrt(L.d)|
%     beta  = arg min |(q-alpha*LLy) ./ sqrt(L.d)|
% ------------------------------------------------------------
     p2 = q2 + 2*Lb;
     alpha = (p2' * Ly) / ssqrLy;
     if abs(alpha*x0) > 2                % Reject excessive values
       alpha = 0.0;
     end
     beta  = (q2' * Ly) / ssqrLy;
     if abs(beta*x0) > 2 | (p0*dp0 < -0.1*p0*p0)
       beta = 0.0;                   % often for infeasible problems
     end
     p = alpha*LLy - p2;                     % optimal p and q
     q = (1-beta*x0) * q2 - (beta*y0) * q;   % i.e. q = q2 - beta *LLy;
% ------------------------------------------------------------
% Instead of [dy;dx0], the vars are now [dy-alpha*y; dx0].
% Moreover, we pre-multiplied the system by [I, 0; -beta*y', 1].
% Thus, we have to update p0 accordingly.
% ------------------------------------------------------------
     p0a = R.sd - c'*DRc;
     p0b = ssqrDc + 1/dsqr(1);
     ax0 = alpha*x0;
     p0  = -beta*y0 * ((1-ax0)*p0a+ax0*p0) ...
          - (1-beta*x0)*((1-ax0)*p0b+alpha*(y0*p0a+2*by));
   else
     alpha = 1/x0;
     beta = 1/x0;
     q = -(beta*y0)*q; p0 = -(beta*y0)*p0;
   end
 else
   alpha = 1/x0;
   beta = 1/x0;
   q = -(beta*y0)*q; p0 = -(beta*y0)*p0;
   Rscl.cx = 0;                  % dummy value, not effectively used.
 end
% ------------------------------------------------------------
% Factorize inner-self-dual system, and write into Lsd structure.
% ------------------------------------------------------------
 Lsd = doinfac(L.d,p0,p,q,L.dep, pars.rimtol);
 Lsd.alpha = alpha;
 Lsd.beta  = beta;
% ------------------------------------------------------------
% Compute dy0-rhs, called Rscl.
% ------------------------------------------------------------
 Rscl.b = ADRc + R.b;
 if beta ~= 1/x0
   Rscl.b0 = (1-beta*x0)*(R.sd+c'*DRc) - beta*y0 * ssqrDRc;
 else
   Rscl.b0 = -(beta*y0)*ssqrDRc;
 end
 Rscl.Rcx = Rcx;
