% LI = doinfac(lab,p0,p,q,dep, tol,maxu)
function LI = doinfac(lab,p0,p,q,dep, tol,maxu)

 if nargin < 7
   maxu = 2;
   if nargin < 6
     tol = 1e-10;
   end
 end
 LI.porg = p;
 LI.m = length(lab);
 lab(dep) = 0;
 [perm,fi,idep] = innerorder(lab,p,dep,maxu,tol);
 LI.pdep = p(dep); LI.qdep = q(dep);
 k = idep(1);
 if k > 0
   p(k) = idep(2);
   q(k) = sum(LI.qdep.^2);
   lab(k) = 0.0;
 end
 p = p(perm);
 q = q(perm);
 lab = lab(perm);
 LI.lm = factorize(lab,p,p0,q,fi);
 LI.idep = idep;
 LI.p = p; LI.q = q; LI.lab = lab;
 LI.perm = perm; LI.fi = fi;
