function [Lden,lab,dep] = deninfac(L,A,adotd,d,rdetd,deptol,maxu)
 Lden = L.den;
% --------------------------------------------------
% Scaling: let AD = Aden * Dden
% --------------------------------------------------
 [m,nden] = size(A.den);
 if nden > 0
   AD = adenscale(A.den, A.blkq, A.dense.qloc, A.dense.cols,...
         d, rdetd(A.dense.qs),adotd);
% --------------------------------------------------
% Correct for sparse part, i.e. let LAD = L\AD
% (this also handles L.perm)
% --------------------------------------------------
   LAD = sparfwslv(L,AD,Lden.LAD);
% --------------------------------------------------
% Remove zero-LP columns (used in final projection)
% --------------------------------------------------
   dden = d(A.dense.cols);
   if length(A.dense.qloc) > 0
     k = A.dense.qloc(1);
     nzden = [find(dden(1:k-1) > 0.0); (k:size(LAD,2))'];  %'
     nden = nden + length(A.dense.qloc);
   else
     nzden = find(dden > 0.0);
   end
% --------------------------------------------------
% Reorder dense rows to get ph2nodes first.
% --------------------------------------------------
   if length(nzden) < nden
     LAD = LAD(:,nzden);
     [Lden.rowperm, colperm, Lden.xsuper] = dpr1order(LAD,...
       A.dense.qloc - (nden-length(nzden)));
   else
     [Lden.rowperm, Lden.xsuper] = ph2dpr1order(Lden.rowperm0,Lden.xsuper0,...
          L.ph2nodes);
     colperm = Lden.colperm;
   end
% --------------------------------------------------
% Factor the dense columns as "diag+rank-1"=diag(L.d)+LAD(:,k)*LAD(:,k)'
% --------------------------------------------------'
   [Lden.p,Lden.pivperm,Lden.beta,Lden.betajc, lab,dep, Lden.dopiv] = ...
     dpr1fact(LAD, L.d, Lden.rowperm, colperm, Lden.xsuper, L.dep, maxu);
 else
% --------------------------------------------------
% If no dense columns
% --------------------------------------------------
   Lden.betajc = [0];
   lab = L.d;
   dep = L.dep;
 end
