% [At,b,depRows] = correctab(At,b,K)
% **********  INTERNAL FUNCTION OF SEDUMI **********
function [newAt,newb,depRows] = correctab(At,b,K)

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %


depRows = [];
[N,m] = size(At);
if issparse(b)
  newb = sparse([],[],[],m,1,nnz(b));
else
  newb = zeros(m,1);
end
newAt = sparse([],[],[],N,m,nnz(At));
inz = 1;
for i = 1:m
  ai = vectril(At(:,i),K);
  if nnz(ai) == 0
    depRows = [depRows i];
    if(b(i) ~= 0.0)
      error('Empty constraint has nonzero in b')
    end
  else
    newAt(:,inz) = ai; 
    newb(inz) = b(i);
    inz = inz + 1;
  end
end
inz = inz - 1;   % number of constraints
if inz < m
  newAt = newAt(:,1:inz);
  newb = newb(1:inz);
end
