/* ************************************************************
   HEADER blksdp.h
   For use with mex-files in self-dual-minimization package.

 %  
 %   This file is part of SeDuMi 1.02   (03AUG1998)
 %   Copyright (C) 1998 Jos F. Sturm
 %   CRL, McMaster University, Canada.
 %   Supported by the Netherlands Organization for Scientific Research (NWO).
 % 
 %   This program is free software; you can redistribute it and/or modify
 %   it under the terms of the GNU General Public License as published by
 %   the Free Software Foundation; either version 2 of the License, or
 %   (at your option) any later version.
 % 
 %   This program is distributed in the hope that it will be useful,
 %   but WITHOUT ANY WARRANTY; without even the implied warranty of
 %   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 %   GNU General Public License for more details.
 % 
 %   You should have received a copy of the GNU General Public License
 %   along with this program; if not, write to the Free Software
 %   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 %

   ************************************************************ */
#if !defined(BLKSDP)
#define BLKSDP
#include "mex.h"

/* ------------------------------------------------------------
   Type definitions:
   ------------------------------------------------------------ */
typedef struct{
 double *pr;
 int *jc, *ir;
    } jcir;

typedef struct{
 double *pr;
 const int *jc;
 const int *ir;
    } constjcir;

typedef struct{
 int lpN,lorN,rconeN,sdpN, rsdpN, qMaxn,rMaxn,hMaxn, rLen,hLen,
   qDim,rDim,hDim;
 const double *lorNL,*rconeNL,*sdpNL;
    } coneK;

/* ------------------------------------------------------------
   Macros:
   ------------------------------------------------------------ */
#if !defined(SQR)
#define SQR(x) ((x)*(x))
#endif

#if !defined(MAX)
#define  MAX(A, B)   ((A) > (B) ? (A) : (B))
#endif

#if !defined(MIN)
#define  MIN(A, B)   ((A) < (B) ? (A) : (B))
#endif

#if !defined(SIGN)
#define  SIGN(A)   (2 * ((A) >= 0) - 1)
#endif

#ifndef M_SQRT2
#define M_SQRT2     1.41421356237309504880	/* sqrt(2) */
#endif
#ifndef M_SQRT1_2
#define M_SQRT1_2   0.70710678118654752440	/* 1/sqrt(2) */
#endif

/* ************************************************************
   INT COMPARE: for searching an int array
   ************************************************************ */
typedef int (*COMPFUN)(const void *pa,const void *pb);
#define ibsearch(key,vec,n)  bsearch((void *)(key), (void *)(vec), (n), \
			    sizeof(int), (COMPFUN) icmp)

/* ------------------------------------------------------------
   Prototypes:
   ------------------------------------------------------------ */
int icmp(const int *a, const int *b);
int intbsearch(int *pi, const int *x, const int n, const int key);
double realssqr(const double *x, const int n);
double realdot(const double *x, const double *y, const int n);
double selrealdot(const double *x, const double *y,
		  const int *sel, const int nnz);
double realdotrow(const double *x, const double *y, const int n);
void tril2sym(double *r, const int n);
void tril2herm(double *r, double *rpi, const int n);
void triu2sym(double *r, const int n);
void triu2herm(double *r, double *rpi, const int n);
void scalarmul(double *r, const double alpha,const double *x,const int n);
void addscalarmul(double *r, const double alpha,const double *x,const int n);
void subscalarmul(double *x, const double alpha, const double *y, const int n);
void realHadamard(double * r, const double *x, const double *y, const int n);
void minusHadamard(double * r, const double *x, const double *y, const int n);
void realHadarow(double * r, const double *x, const double *y, const int n);
void realHadadiv(double * r, const double *x, const double *y, const int n);
void fzeros(double *z,const int n);
void conepars(const mxArray *mxK, coneK *pK);
void someStats(int *pxmax, int *pxsum, int *pxssqr,
	       const double *x, const int n);
void qlmul(double *z,const double *x,const double *y,
	   const double rdetx,const int n);
void qldiv(double *z,const double *x,const double *y,
	   const double rdetx,const int n);
void vec2blks(int *blklocs, const int *blkstart, const int *yir,
              const int ystart, const int ynnz, const int nblk);
void vec2selblks(int *blklocs, const int *blkstart, const int *yir,
                 const int ystart, const int ynnz,
                 const int *blkir, const int blknnz);
int spscaleK(double *z, const int *dzjc, const int *dzir,
             jcir y, const int *yblkir, const int yblknnz,
             const int *blkstart,
             const double *x, const double *xsqr, const double *detx,
             const double *uxsqr,
             const coneK cK, const int *blkNL,
             double *fwork, int *iwork,
             int *xdotyIr, double *xdotyPr);
void uperm(double *y, const double *u, const int *perm, const int n);
void dodiscard(int *xir,int *xnnz, const int *xjc,
              const int *perm,const char *discard, const int m);
/* ------------------------------------------------------------
   For vecsym:
   ------------------------------------------------------------ */
void vecsymPSD(double *y, const double *x,const int rsdpN,const int sdpN,
               const double *sdpNL);
/* ------------------------------------------------------------
   For auxfwdpr1:
   ------------------------------------------------------------ */
void fwipr1(double *y, const double *p, const double *beta,
            const int m, const int n);
void fwipr1o(double *y, const int *perm, const double *p, const double *beta,
             const int m, const int n);
#endif
