###########################################################################
# Makefile for SeDuMi, makes DLL-files out of C-files.
# For DOS (i.e. NT/win95/win98/etc.). See "Makefile" for UNIX version.
# Use  "make" (Borland) or "nmake -f Makefile.mak" (Microsoft)
# Uninstall by issuing "del *.dll" from the command prompt.
#
# NOTE: at the DOS prompt, type
#   set MATLABROOT=c:\matlab
#   set MATLAB=%MATLABROOT%
# before invoking nmake. The above assumes MATLAB is installed under
# c:\matlab. Another popular place is:
#   set MATLABROOT="C:\Windows\Application Data\Mathworks\Matlab"
#
# See the file `Install.dos' for details.
#
# This file is part of SeDuMi 1.03
# Copyright (C) 1998 Jos F. Sturm
# Dept. of Quantitative Economics, Maastricht University, The Netherlands.
# Part was developed between 1/10/97 and 1/10/98, with affiliation
#   CRL, McMaster University, Canada,
#   and Netherlands Organization for Scientific Research (NWO).
#
###########################################################################

##### Instead of setting the MATLABROOT environment variable,
##### you may define it below: (by uncommenting)
#MATLABROOT = c:\matlab

# If your system does not have PERL, then use "PERL=call".
#PERL=perl
PERL=call
MEX=$(PERL) $(MATLABROOT)\bin\mex.bat
MEXFLAGS =-I$(MATLABROOT)\extern\include

# standard options are provided in this file, which is sourced prior
# to every mex command.  You may want to add your own compiler specific
# options to this file, or rewrite the file itself to suit your needs.
# WARNING: Matlab R11 users should uncomment the definition without "\bin".
MEXOPTS= $(MATLAB)\bin\mexopts.bat
#MEXOPTS=$(MATLABROOT)\mexopts.bat

# Extension of DLL-executable libraries is dll
ST=dll

#
# C to MEX compilation rule
#
.c.dll:
	$(MEX) -f $(MEXOPTS) $(MEXFLAGS) $*.c

# To uninstall the mex-files, type "del *.dll"

# Having made the DOS-specific macro definitions, proceed with the
# common makefile for SeDuMi.
# WARNING: users of the lcc compiler Make (delivered with Matlab R11) must
# include "Makefile.sedumi" physically (using a text editor).
include Makefile.sedumi
