function [index, bins_1_new, bins_2_new, bins_intersect_new]=pickfdmbin(pmax_1,pmax_2,h_1, h_2, bins_1, bins_2, bins_intersect, deta)

l=length(h_1);
bins=1:l;
p_1_initial=zeros(1,l);
p_2_initial=zeros(1,l);
if isempty(bins_1)==0
    p_1_initial(bins_1) = wf(pmax_1,h_1(bins_1),deta);
    r_1_initial=sum(log2(1+h_1.^2.*p_1_initial./deta));
else
    r_1_initial=0;
end

if isempty(bins_2)==0
    p_2_initial(bins_2) = wf(pmax_2,h_2(bins_2),deta);
    r_2_initial=sum(log2(1+h_2.^2.*p_2_initial./deta));
else
    r_2_initial=0;
end

n_1=length(bins_intersect);

for i=1:n_1
    k_temp=bins_intersect(i);
    bins_2_temp=union(bins_2,k_temp);
    p_2_temp=zeros(1,l);
    p_2_temp(bins_2_temp)=wf(pmax_2, h_2(bins_2_temp),deta);
    r_2_temp(i)=sum(log2(1+h_2.^2.*p_2_temp./deta));
    bins_2_temp=find(p_2_temp~=0);
    bins_2_left=setdiff(bins,bins_2_temp);
    p_1_temp=zeros(1,l);
    p_1_temp(bins_2_left)=wf(pmax_1, h_1(bins_2_left),deta);
    bins_1_temp=find(p_1_temp~=0);
    r_1_temp(i)=sum(log2(1+h_1.^2.*p_1_temp./deta));
end
    
dr_1=r_1_initial-r_1_temp;
dr_2=r_2_temp-r_2_initial;

dr1_2=dr_1./dr_2;
[val, k]=min(dr1_2);
index=bins_intersect(k);
bins_intersect_new=bins_intersect;
bins_intersect_new(k)=[];


bins_2_new=union(bins_2,index);

p_2_new=zeros(1,l);
p_2_new(bins_2_new)=wf(pmax_2, h_2(bins_2_new),deta);
bins_2_new=find(p_2_new~=0);
bins_2_left=setdiff(bins,bins_2_new); 
p_1_new=zeros(1,l);
p_1_new(bins_2_left)=wf(pmax_1, h_1(bins_2_left),deta);
bins_1_new=find(p_1_new~=0);


