% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 


function [NF_max, alpha_max, p_max_1, p_max_2, r_max_1, r_max_2] = optimalFDMts(H,P_max,P_sp,np)
n=length(H);
p_allo=zeros(2*n,2^n);
r_allo=zeros(2,2^n);
options=optimset('Gradobj','on');
warning  off ;

p_ideal_1=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(1)*ones(n,1),[],[],zeros(n,1),P_sp(1,:)',[],[],H(1,:)',np);
bin_ideal_1=p_ideal_1>10^-3;
p_ideal_2=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(2)*ones(n,1),[],[],zeros(n,1),P_sp(2,:)',[],[],H(2,:)',np);
bin_ideal_2=p_ideal_2>10^-3;
bin_comp=bin_ideal_1.*bin_ideal_2;
n_comp=sum(bin_comp);

if n_comp==0
    p_max_1=p_ideal_1;
    r_max_1=sum(log2(ones(n,1)+p_ideal_1.*H(1,:)'.^2/np));
    p_max_2=p_ideal_2;
    r_max_2=sum(log2(ones(n,1)+p_ideal_2.*H(2,:)'.^2/np));
    alpha_max=0;
    NF_max=log2(r_max_1)+log2(r_max_2);

else
    for j=1:2^n
        strj=dec2bin(j-1,n);
        stringlength=length(strj);
        for k=1:n
            binaryj(k)=str2double(strj(k));
        end
        H_copy=H;
        H_copy(1,binaryj==1)=0;
        h_1=H_copy(1,:)';
        H_copy(2,binaryj==0)=0;
        h_2=H_copy(2,:)';
        p_allo(1:n,j)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(1)*ones(n,1),[],[],zeros(n,1),P_sp(1,:)',[],[],h_1,np);% optimal power allocation for user 1 at this round
        p_allo(n+1:2*n,j)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(2)*ones(n,1),[],[],zeros(n,1),P_sp(2,:)',[],[],h_2,np);% optimal power allocation for user 2 at this round
        r_allo(1,j)=sum(log2(ones(n,1)+p_allo(1:n,j).*h_1.^2/np));
        r_allo(2,j)=sum(log2(ones(n,1)+p_allo(n+1:2*n,j).*h_2.^2/np));
    end

    [r(1,:),IX]=sort(r_allo(1,:),'descend');% 1
    r(2,:)=r_allo(2,IX); %2
    p_allo=p_allo(:,IX); %3, 1-3 sort r  and p according to descend r_1

    ind=find(r(2,:)==0);
    [temp,indmax]=max(r(2,ind));
    temp=r(:,indmax);
    r(:,indmax)=r(:,1);
    r(:,1)=temp;

    k=1;
    while(k<length(r))
        l=k;
        while(l<length(r))
            %         if(r(1,k)-r(1,l+1)<=0&&r(2,k)-r(2,l+1)<=0)
            %            r(:,l)=[];
            %            p_allo(:,l)=[];
            %            k=k-1;
            %            l=length(r);
            %         else
            if(r(1,k)-r(1,l+1)>=0&&r(2,k)-r(2,l+1)>=0&&r(1,l+1)~=0)
                r(:,l+1)=[];
                p_allo(:,l+1)=[];
                l=l-1;
            end
            l=l+1;
        end
        k=k+1;
    end

    anchor=1;
    while(anchor<length(r))
        slope=[];
        %     samer1=find(r(1,:)==r(1,anchor));
        %     [r2max_samer1,bin]=max(r(2,samer1));
        %     samer1(bin)=[];
        %     r(:,samer1)=[]; %above 4 lines delete same r1 but less r2 rate points
        k=1;
        for j=anchor:length(r)-1
            slope(k)=(r(1,anchor)-r(1,j+1))/(r(2,anchor)-r(2,j+1));
            k=k+1;
        end
        [C,I] = max(slope);
        if anchor+1<anchor+I
            r(:,anchor+1:anchor+I-1)=[];
            p_allo(:,anchor+1:anchor+I-1)=[];
        end
        anchor=anchor+1;
    end

    % plot(r(1,:),r(2,:),'x');
    % hold on

    for j=1:length(r)-1
        x1=r(:,j);
        x2=r(:,j+1);
        alpha(j)=fmincon(@objective,0,[x2(1)-x1(1);x2(2)-x1(2)],[x2(1);x2(2)],[],[],0,1,[],[],x1,x2);
        NF(j)=log2(alpha(j)*x1(1)+(1-alpha(j))*x2(1))+log2(alpha(j)*x1(2)+(1-alpha(j))*x2(2));
    end
    [NF_max,index] = max(NF);
    alpha_max=alpha(index);
    p_max_1=p_allo(:,index);
    p_max_2=p_allo(:,index+1);
    r_max_1=alpha_max*sum(log2(ones(n,1)+p_max_1(1:n,1).*H(1,:)'.^2/np))+(1-alpha_max)*sum(log2(ones(n,1)+p_max_2(1:n,1).*H(1,:)'.^2/np));
    r_max_2=alpha_max*sum(log2(ones(n,1)+p_max_1(n+1:2*n,1).*H(2,:)'.^2/np))+(1-alpha_max)*sum(log2(ones(n,1)+p_max_2(n+1:2*n,1).*H(2,:)'.^2/np));
end

% 1 to n rows are p_1, n+1 to 2n rows are p-2
%[NF_max, alpha_max, p_max_1,p_max_2] = optimalFDMts(H,P_max,P_sp,np)
% H=[0.6 0.9 0.8 0.7; 0.8 0.8 0.6 0.6]
% P_max=[2,2]
% P_sp=[1 1 1 1; 1 1 1 1]
% np=1