% example 4 (fig. 7, fig. 8) 
% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 

clear
nstart=4;
nend=8;
figure(1);
r_max=[];
r_max_sub=[];
i=1;
% counter=1;

while(i<=50)
    H_pool=raylrnd(1,2,nend);
    P_sp_pool=ones(2,nend)+unifrnd(0.3,0.35,2,nend);
    for nbins=nstart:nend
        H=H_pool(:,1:nbins);
        for j=1:3
        p_max=1.5+(j-1)*0.5;
        P_max=[p_max,p_max];
        P_sp=P_sp_pool(:,1:nbins);
        np=1;
        [NF_max, alpha_max, p_max_1, p_max_2, r_max_1, r_max_2] = optimalFDMts(H,P_max,P_sp,np);
        [NF_max_sub, alpha_max_sub, p_max_1_sub, p_max_2_sub, r_max_1_sub, r_max_2_sub] = suboptFDMsts(H,P_max,P_sp,np);
%        if r_max_1*r_max_2*r_max_1_sub*r_max_2_sub~=0
            l=(i-1)*(nend-nstart+1)+nbins-nstart+1;
            r_max(1,l)=r_max_1;
            r_max(2,l)=r_max_2;
            r_max_sub(1,l)=r_max_1_sub;
            r_max_sub(2,l)=r_max_2_sub;
            NF_m(nbins-nstart+1,i,j)=NF_max;
            NF_s(nbins-nstart+1,i,j)=NF_max_sub;
%             if NF_max==NF_max_sub
%                 counter=counter+1;
%             end
            %plot(r_max_1,r_max_2,'rp');
            %plot(r_max_1_sub,r_max_2_sub,'s');
            %line([r_max_1,r_max_1_sub],[r_max_2,r_max_2_sub],'color','g'); 
            %k=nbins-nstart+1;
            %dif(k,i)=abs(NF_max-NF_max_sub)/NF_max;
        end
%        end
    end
    i=i+1;
end
% dif_nonzero= sum(dif>10^-5,2);
NF_m_mean(:,1)=mean(NF_m(:,:,1),2);
NF_m_mean(:,2)=mean(NF_m(:,:,2),2);
NF_m_mean(:,3)=mean(NF_m(:,:,3),2);
NF_s_mean(:,1)=mean(NF_s(:,:,1),2);
NF_s_mean(:,2)=mean(NF_s(:,:,2),2);
NF_s_mean(:,3)=mean(NF_s(:,:,3),2);
% d_mean=sum(dif,2)./sum(dif~=0,2);
hold on
box on
grid on
plot(r_max(1,:),r_max(2,:),'rp');
plot(r_max_sub(1,:),r_max_sub(2,:),'s');
legend('OPtimal solution', 'Sub-optimal solution')
line([r_max(1,:);r_max_sub(1,:)],[r_max(2,:);r_max_sub(2,:)],'color','g');
hold off
xlabel('R_1');
ylabel('R_2');
nn=nstart:nend;
% figure(2)
% box on
% plot(nn,d_mean,'--rs','LineWidth',2,'MarkerEdgeColor','k','MarkerFaceColor','g','MarkerSize',10);
% grid on
figure(2)
hold on
plot(nn,NF_m_mean(:,1),'-rd','color','r');
plot(nn,NF_s_mean(:,1),'-s','color','b');
plot(nn,NF_m_mean(:,2),'-rd','color','r');
plot(nn,NF_s_mean(:,2),'-s','color','b');
plot(nn,NF_m_mean(:,3),'-rd','color','r');
plot(nn,NF_s_mean(:,3),'-s','color','b');
box on
grid on
hold off