% example 3 (fig. 6)
% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 


bins=256;
H=raylrnd(1,2,bins);
ratio=H(1,:)./H(2,:);
[B,IX] = sort(ratio,'descend');
H=H(:,IX);
P_sp_all=1*ones(2,bins)+unifrnd(-0.2,0.2,2,bins);
P_sp_all=P_sp_all(:,IX);
for n_bin=1:256 % frequency bins
    for tp=1:100 % total power
        i=1;
        total_power=1+0.5*tp;
        while(i<=100)
            P_sp=P_sp_all(:,1:n_bin);
            k_up=1;
            k_down=n_bin;
            flag_up=1;
            flag_down=1;
            power_1=total_power;
            power_2=total_power;
            while(flag_up||flag_down)
                if(k_up==n_bin||power_1-P_sp(1,k_up)<0)
                    flag_up=0;
                    if(power_1/P_sp(1,k_up)<=1)
                        d_1(i)=k_up-1+power_1/P_sp(1,k_up);
                    else
                        d_1(i)=k_up;  
                    end
                else
                    power_1=power_1-P_sp(1,k_up);
                    k_up=k_up+1;
                end
                if(k_down==1||power_2-P_sp(1,k_down)<0)
                    flag_down=0;
                    if(power_2/P_sp(2,k_down)<=1)
                        d_2(i)=k_down-power_2/P_sp(2,k_down);
                    else
                        d_2(i)=k_down-1;
                    end
                else
                    power_2=power_2-P_sp(1,k_down);
                    k_down=k_down-1;                    
                end
                d_temp(i)=(d_2(i)-d_1(i))/n_bin;
            end
            i=i+1;
        end
        i=i-1;
        d(tp,n_bin)=mean(d_temp(i));
    end
end

%thred=zeros(tp/4,n_bin/4);
%mesh(1:4:n_bin,1+0.5*[1:4:tp],thred,'EdgeColor','c');
% hold on
mesh(1:n_bin,1+0.5*[1:tp],d);
box on
grid on
xlabel('N')
ylabel('P_i')
zlabel('\tau')