% example 1 (fig. 1, fig. 2)

% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 

clear
nbin=4;
Hd11=raylrnd(1,nbin,1);
Hd12=raylrnd(0.7,nbin,1);
Hd21=raylrnd(0.2,nbin,1);
Hd22=raylrnd(1,nbin,1);
pmax=raylrnd(1,nbin,1);
np1=0.01;
np2=0.01;
step=0.01;

for j=1:nbin

for i=1:nbin

W(i,j)=exp(sqrt(-1)*2*pi*(i-1)*(j-1)/nbin)/sqrt(nbin);

if j==i

LmdMtr(i,j)=sqrt(pmax(i));

Omg11(i,j)=Hd11(i);

Omg12(i,j)=Hd12(i);

Omg21(i,j)=Hd21(i);

Omg22(i,j)=Hd22(i);

else

LmdMtr(i,j)=0;

Omg11(i,j)=0;

Omg12(i,j)=0;

Omg21(i,j)=0;

Omg22(i,j)=0;

end

end

end


H11=W*Omg11*W';

H12=W*Omg12*W';

H21=W*Omg21*W';

H22=W*Omg22*W';


F1_NE=W*LmdMtr;
F2_NE=W*LmdMtr;

R_inv1= inv(np1* eye(nbin)+H21*F2_NE*F2_NE'*H21');
R_inv2= inv(np2* eye(nbin)+H12*F1_NE*F1_NE'*H12');

R1_NE=log2(abs(det(eye(nbin)+F1_NE'*H11'*R_inv1*H11*F1_NE)))/nbin;
R2_NE=log2(abs(det(eye(nbin)+F2_NE'*H22'*R_inv2*H22*F2_NE)))/nbin;

for i=1:nbin
    r1(i)=log2(1+(Hd11(i)*pmax(i))^2/np1)/nbin;
    r2(i)=log2(1+(Hd22(i)*pmax(i))^2/np2)/nbin;
    l(i)=r1(i)/r2(i);
end

for i=1:nbin
     [lv,index1]=max(l);
     r1_order(i)=r1(index1);
     r2_order(i)=r2(index1);
     l(index1)=-5;
end

R1_coop=0;
R2_coop=sum(r2_order);

for k=1:nbin
      k_mesh(k)=k;
  for alpha=0:step:1
      tn=alpha/step+1;
      t=uint16((k-1)*(1/step+1)+alpha/step+1);
      r1_order_alpha(k)=alpha*r1_order(k);
      r2_order_alpha(k)=alpha*r2_order(k);

    if k==1
       R1_coop(t)=0+ r1_order_alpha(k);
       R2_coop(t)=sum(r2_order(1:nbin))- r2_order_alpha(k);
    elseif k==nbin
       R1_coop(t)=sum(r1_order(1:nbin-1))+r1_order_alpha(k);
       R2_coop(t)=(1-alpha)*r2_order(k);    
    else
       R1_coop(t)=sum(r1_order(1:k-1))+ r1_order_alpha(k);
       R2_coop(t)=sum(r2_order(k:nbin))- r2_order_alpha(k);
    end  
    R1_gain(t)=R1_coop(t)-R1_NE;
    R2_gain(t)=R2_coop(t)-R2_NE;
%    if R1_gain(t)<0||R2_gain(t)<0
%       nashfunc(t)=0;
%    else
       nashfunc(t)=R1_gain(t)*R2_gain(t);
%    end
  end
end

[maxnash,index]=max(nashfunc);
alpha_op=(index-1)*step;
R1_nb=R1_coop(index);
R2_nb=R2_coop(index);

xl=9;
yl=0;
k=1;
while(xl>0&&yl<8)
k;
xp(k)=max(R1_coop)-((max(R1_coop)-R1_NE)/100)*k;
yp(k)=maxnash/(xp(k)-R1_NE)+R2_NE;
xl=xp(k);
yl=yp(k);
k=k+1;
end
    
figure
hold on
axis on
grid on
box on
plot(R1_coop,R2_coop)
plot(R1_NE,R2_NE,'.')
plot(R1_nb,R2_nb,'*')
plot(xp,yp,'--')
hold off

for i=1:nbin
    nashfunc_mesh(:,i)=nashfunc((i-1)*101+1:i*101);
end
figure
[k_mesh,alpha_mesh]=meshgrid(1:nbin,0:step:1);
surf(k_mesh,alpha_mesh,nashfunc_mesh,'EdgeColor','black')