%waterfilling function

% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 

function p = wf(pmax,h,deta)
x=h.^2./deta; % deta is the noise power, cm= |h|^2/deta is the channel measure \alpha
n_l=length(x);
nn=length(x);
bin_index=1:nn;
z=zeros(1,nn);
gamma=1/nn*(pmax+sum(1./x)); % gamma=1/lambda
p=gamma-1./x;
flag=(p>=z);
x_copy=x;

while(min(flag)==0)
[value,j]=min(x_copy);
% k=bin_index(j);
x_new=x_copy;
x_new(j)=[];
bin_index(j)=[];
nn=nn-1;
z=zeros(1,nn);
gamma=1/nn*(pmax+sum(1./x_new));
p_new=gamma-1./x_new;
p=zeros(1,n_l);
p(bin_index)=p_new;
% if k==1
% p(1)=0;
% p(2:nn+1)=p_new(1:nn);
% x_copy=x_new;
% else 
% p(1:k-1)=p_new(1:k-1);
% p(k)=0;
% p(k+1:nn+1)=p_new(k:nn);
% x_copy=x_new;
% end
x_copy=x_new;
flag=(p_new>=z);
end