% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 


function [NF_max, alpha_max, p_max_1, p_max_2,r_max_1, r_max_2] = suboptFDMsts(H,P_max,P_sp,np)
n=length(H);
p_ideal_1=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(1)*ones(n,1),[],[],zeros(n,1),P_sp(1,:)',[],[],H(1,:)',np);
bin_ideal_1=p_ideal_1>10^-3;
p_ideal_2=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(2)*ones(n,1),[],[],zeros(n,1),P_sp(2,:)',[],[],H(2,:)',np);
bin_ideal_2=p_ideal_2>10^-3;
bin_comp=bin_ideal_1.*bin_ideal_2;
n_comp=sum(bin_comp);
one_vec=ones(1,n);



if n_comp==0    % if n_comp=0, then the index 2*n_comp will trigger error. And in the case n_comp=0, there should be 2 points, so 2*n_comp=2, n_comp=1
    p_max_1=p_ideal_1;
    r_max_1=sum(log2(ones(n,1)+p_ideal_1.*H(1,:)'.^2/np));
    p_max_2=p_ideal_2;
    r_max_2=sum(log2(ones(n,1)+p_ideal_2.*H(2,:)'.^2/np));
    alpha_max=0;
    NF_max=log2(r_max_1)+log2(r_max_2);
elseif n_comp>=1
    bin(1:n,1)=bin_ideal_1';% first round for user 1
    p(1:n,1)=p_ideal_1;
    r(1,1)=sum(log2(ones(n,1)+p_ideal_1.*H(1,:)'.^2/np));
    bin(n+1:2*n,1)=one_vec'-bin_ideal_1; % bin allocated to user 2 at round 1
    p(n+1:2*n,1)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(2)*ones(n,1),[],[],zeros(n,1),P_sp(2,:)',[],[],bin(n+1:2*n,1).*H(2,:)',np);
    r(2,1)=sum(log2(ones(n,1)+p(n+1:2*n,1).*H(2,:)'.^2/np));

    if (n_comp>1)
        bin_comp_copy_1=bin_comp;
        bin_1_available=one_vec'

        for i=1:n_comp-1 % l-1 rounds favor r_1
            H_comp_1=H(1,:)'.*bin_comp_copy_1;
            bin_index=find(H_comp_1~=0);
            [a,b]=min(H(1,bin_index));
            bin_transfer=bin_index(b);
            bin_comp_copy_1(bin_transfer)=0;
            bin_1_available(bin_transfer)=0;
            p(1:n,i+1)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(1)*ones(n,1),[],[],zeros(n,1),P_sp(1,:)',[],[],bin_1_available.*H(1,:)',np);
            bin(1:n,i+1)=p(1:n,i+1)>10^-3;
            r(1,i+1)=sum(log2(ones(n,1)+p(1:n,i+1).*H(1,:)'.^2/np));
            bin(n+1:2*n,i+1)=one_vec'-bin(1:n,i+1);
            p(n+1:2*n,i+1)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(2)*ones(n,1),[],[],zeros(n,1),P_sp(2,:)',[],[],bin(n+1:2*n,i+1).*H(2,:)',np);
            r(2,i+1)=sum(log2(ones(n,1)+p(n+1:2*n,i+1).*H(2,:)'.^2/np));
        end

        bin_comp_copy_2=bin_comp;
        bin_2_available=one_vec'
        for i=n_comp:2*n_comp-2 %L-1 rounds favor r_2
            H_comp_2=H(2,:)'.*bin_comp_copy_2;
            bin_index=find(H_comp_2~=0);
            [a,b]=min(H(2,bin_index));
            bin_transfer=bin_index(b);
            bin_comp_copy_2(bin_transfer)=0;
            bin_2_available(bin_transfer)=0;
            p(n+1:2*n,i+1)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(2)*ones(n,1),[],[],zeros(n,1),P_sp(2,:)',[],[],bin_2_available.*H(2,:)',np);
            bin(n+1:2*n,i+1)=p(n+1:2*n,i+1)>10^-3;
            r(2,i+1)=sum(log2(ones(n,1)+p(n+1:2*n,i+1).*H(2,:)'.^2/np));
            bin(1:n,i+1)=one_vec'-bin(n+1:2*n,i+1);
            p(1:n,i+1)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(1)*ones(n,1),[],[],zeros(n,1),P_sp(1,:)',[],[],bin(1:n,i+1).*H(1,:)',np);
            r(1,i+1)=sum(log2(ones(n,1)+p(1:n,i+1).*H(1,:)'.^2/np));
        end
    end
    bin(n+1:2*n,2*n_comp)=bin_ideal_2';% first(best) round for user 2
    p(n+1:2*n,2*n_comp)=p_ideal_2;
    r(2,2*n_comp)=sum(log2(ones(n,1)+p_ideal_2.*H(2,:)'.^2/np));
    bin(1:n,2*n_comp)=one_vec'-bin_ideal_2; % bin allocated to user 1 at this round
    p(1:n,2*n_comp)=fmincon(@objectivewftp,zeros(n,1),ones(n,n),P_max(1)*ones(n,1),[],[],zeros(n,1),P_sp(1,:)',[],[],bin(1:n,2*n_comp).*H(1,:)',np);
    r(1,2*n_comp)=sum(log2(ones(n,1)+p(1:n,2*n_comp).*H(1,:)'.^2/np))


    [r(1,:),IX]=sort(r(1,:),'descend');% 1
    r(2,:)=r(2,IX); %2
    p=p(:,IX); %3, 1-3 sort r  and p according to descend r_1

    [row,col]=size(r);
    if col>2
        k=1;
        while(k<length(r)) % delete obvious pareto-dominated points
            l=k;
            while(l<length(r))
                if (r(1,k)-r(1,l+1)>=0&&r(2,k)-r(2,l+1)>=0&&r(1,l+1)~=0)
                    r(:,l+1)=[];
                    p(:,l+1)=[];
                    l=l-1;
                end
                l=l+1;
            end
            k=k+1;
        end

        anchor=1;
        while(anchor<length(r)) % delete pareto dominated points in time sharing
            slope=[];
            k=1;
            for j=anchor:length(r)-1
                slope(k)=(r(1,anchor)-r(1,j+1))/(r(2,anchor)-r(2,j+1));
                k=k+1;
            end
            [C,I] = max(slope);
            if anchor+1<anchor+I
                r(:,anchor+1:anchor+I-1)=[];
                p(:,anchor+1:anchor+I-1)=[];
            end
            anchor=anchor+1;
        end
    end

    % plot(r(1,:),r(2,:),'ro');
    % hold on

    for j=1:length(r)-1
        x1=r(:,j);
        x2=r(:,j+1);
        alpha(j)=fmincon(@objective,0,[x2(1)-x1(1);x2(2)-x1(2)],[x2(1);x2(2)],[],[],0,1,[],[],x1,x2);
        NF(j)=log2(alpha(j)*x1(1)+(1-alpha(j))*x2(1))+log2(alpha(j)*x1(2)+(1-alpha(j))*x2(2));
    end
    [NF_max,index] = max(NF);
    alpha_max=alpha(index);
    p_max_1=p(:,index);
    p_max_2=p(:,index+1);
    r_max_1=alpha_max*sum(log2(ones(n,1)+p_max_1(1:n,1).*H(1,:)'.^2/np))+(1-alpha_max)*sum(log2(ones(n,1)+p_max_2(1:n,1).*H(1,:)'.^2/np));
    r_max_2=alpha_max*sum(log2(ones(n,1)+p_max_1(n+1:2*n,1).*H(2,:)'.^2/np))+(1-alpha_max)*sum(log2(ones(n,1)+p_max_2(n+1:2*n,1).*H(2,:)'.^2/np));
end