function [p_1fdm, p_2fdm, p_1wf, p_2wf, r_1fdm, r_2fdm, r_1wf, r_2wf] = iterwf(pmax_1,pmax_2,h_1,h_2, hinter_1, hinter_2, bins_1, bins_2, k, deta) % iterative waterfilling
%hinter_1, hinter_2 are the interference channel for the shared bin, the
%index of the shared bin in h_1 and h_2 are k and k.

l=length(h_1);
%following are FDM results

p_1fdm=zeros(1,l);
p_2fdm=zeros(1,l);
if isempty(bins_1)==0
    p_1fdm(bins_1) = wf(pmax_1,h_1(bins_1),deta);
    r_1fdm=sum(log2(1+h_1.^2.*p_1fdm./deta));
else
    r_1fdm=0;
end
if isempty(bins_2)==0
    p_2fdm(bins_2) = wf(pmax_2,h_2(bins_2),deta);
    r_2fdm=sum(log2(1+h_2.^2.*p_2_initial./deta));
else
    r_2fdm=0;
end

%FDM ends

%intial for waterfilling
deta_1=ones(1,l).*deta;
deta_2=ones(1,l).*deta;
%initial noise+interference power for user 2
deta_2(k)=deta_2(k)+hinter_1(k)^2*p_1fdm(k);

p_2=zeros(1,l);
p_1=p_1fdm;
bins_2wf=union(bins_2,k);
num=10;
r_1=zeros(1,num);
r_2=zeros(1,num);
NF=zeros(1,num);
% following are iterative waterfilling
flag=1;
i=1;


while(i<=num&&flag==1)
    if mod(i,2)==1
        p_2(bins_2wf)=wf(pmax_2,h_2(bins_2wf),deta_2);
        r_2(i)=sum(log2(1+h_2.^2.*p_2./deta_2));
        deta_1(k)=deta_1(k)+hinter_2(k)^2*p_2(k);
        r_1(i)=sum(log2(1+h_1.^2.*p_1./deta_1));
      
        p_1wf=p_1;
        p_2wf=p_2;
        r_1wf=r_1(i);
        r_2wf=r_2(i);
        
        NF(i)=r_1(i)*r_2(i);
        NF_fdm=r_1fdm* r_2fdm;

        if i==1
            if NF(i)<NF_fdm
                flag=0;
            end
        elseif NF(i)<NF(i-1)
            flag=0;
            r_1wf=r_1(i-1);
            r_2wf=r_2(i-1);
        end

        i=i+1;

    else
        p_1=wf(pmax_1,h_1,deta_1);
        r_1(i)=sum(log2(1+h_1.^2.*p_1./deta_1));
        deta_2(k)=deta_2(k)+hinter_1^2*p_1(k);
        r_2(i)=sum(log2(1+h_2.^2.*p_2./deta_2));
                  
        p_1wf=p_1;
        p_2wf=p_2;
        r_1wf=r_1(i);
        r_2wf=r_2(i);
        
        NF(i)=r_1(i)*r_2(i);
        
        if NF(i)<NF(i-1)
            flag=0;
            r_1wf=r_1(i-1);
            r_2wf=r_2(i-1);
        end
        i=i+1;
    end
end
