% example 2 (fig. 5)

% Cooperative Precoding/Resource Allocation Games under Spectral Mask and Total Power Constraints
% copyright Jie Gao, Sergiy A. Vorobyov and Hai Jiang, SEP, 2009
% email: jgao3@ece.ualberta.ca 

clear
nuser=4;
nbin=6;
Hd=zeros(nbin,nuser,nuser);
pmax=zeros(nbin,nuser);
np=zeros(nuser,1);
LmdMtr=zeros(nbin,nbin,nuser);
Omg=cell(nuser,nuser);
W=zeros(nbin,nbin);
H=cell(nuser,nuser);
F_NE=zeros(nbin,nbin,nuser);
Interfere=zeros(nbin,nbin,nuser);
R_inv=zeros(nbin,nbin,nuser);
r=zeros(nbin,nuser);
R_NE=zeros(nuser,1);
lambda(:,1)=1*ones(nbin,1);% intial lambda
alpha=zeros(nbin,nuser);%time proportion
alphalowbound=zeros(nbin,1);
alphahighbound=ones(nbin,1);
iter=1; %number of iterations
epsilon=10^(-5); % stopping criterion
R_co=zeros(nuser,1);
NF=zeros(1,1,1);
NF_steplength=cell(1);
for i=1:nuser

    randmax=1;
    randlist=0.2*ones(nuser-1);

    k=1;
    for j=1:nuser
        if j==i
            Hd(1:nbin,j,i)=raylrnd(randmax,nbin,1);
        else
            Hd(1:nbin,j,i)=raylrnd(randlist(k),nbin,1);
            k=k+1;
        end
    end
    pmax(1:nbin,i)=raylrnd(1,nbin,1);
    np(i)=0.01;
end

for j=1:nbin
    for i=1:nbin
        W(i,j)=exp(sqrt(-1)*2*pi*(i-1)*(j-1)/nbin)/sqrt(nbin);
        for k=1:nuser
            for m=1:nuser
                if j==i
                    LmdMtr(i,j,k)=sqrt(pmax(i,k));
                    Omg{m,k}(i,j)=sqrt(Hd(i,m,k));
                else
                    LmdMtr(i,j,k)=0;
                    Omg{m,k}(i,j)=0;
                end
            end
        end
    end
end

for k=1:nuser
    F_NE(:,:,k)=W*LmdMtr(:,:,k);
end

for k=1:nuser
    for m=1:nuser
        H{m,k}=W*Omg{m,k}*W';
        if m~=k
            Interfere(:,:,k)=Interfere(:,:,k)+H{m,k}*F_NE(:,:,m)*F_NE(:,:,m)'*H{m,k}';
        end
    end
    R_inv(:,:,k)=inv(np(k)* eye(nbin)+Interfere(:,:,k));
end

% R1_NE=log2(abs(det(eye(nbin)+F1_NE'*H11'*R_inv1*H11*F1_NE)))/nbin;
% R2_NE=log2(abs(det(eye(nbin)+F2_NE'*H22'*R_inv2*H22*F2_NE)))/nbin;

for k=1:nuser
    R_NE(k)=log2(abs(det(eye(nbin)+F_NE(:,:,k)'*H{k,k}'*R_inv(:,:,k)*H{k,k}*F_NE(:,:,k))))/nbin;
    for i=1:nbin
        r(i,k)=log2(1+(Hd(i,k,k)*pmax(i,k))^2/np(k))/nbin;
    end
end

count=1;
options=optimset('Gradobj','on');
for steplength=0.3:-0.1:0.1
    iter=1;
    NF=[];
    while(iter==1||abs((norm(lambda(:,iter)-lambda(:,iter-1)))/norm(lambda(:,iter-1)))>=epsilon)
        for k=1:nuser
            warning  off ;
            alpha(:,k) = fmincon(@objective,lambda(:,iter),-r(:,k)',-R_NE(k),[],[],alphalowbound,alphahighbound,[],options,r(:,k),lambda(:,iter));
        end
        iter=iter+1;
        for j=1:nbin
            if lambda(j,iter-1)-steplength*(1-sum(alpha(j,:)))>=0
                lambda(j,iter)=lambda(j,iter-1)-steplength*(1-sum(alpha(j,:)));
            else
                lambda(j,iter)=0;
            end
        end

        R_co(:,iter-1)=sum(alpha.*r);
        NF(iter-1)=1;
        for j=1:nuser
            NF(iter-1)=NF(iter-1)*(R_co(j,iter-1)-R_NE(j));
        end

        steplength=0.99*steplength;
    end
    NF_steplength{count}=NF;
    count=count+1;
    niter=iter-1;
end

steplegnth=[0.3,0.2,0.1];
figure
hold on
for i=1:count-1
    subplot(count-1,1,i)
    plot(NF_steplength{i},'r-')
    box on
    grid on
    xlabel('number of iterations')
    ylabel('NF')
    legend(['\sigma=' num2str(steplegnth(i))])
end
% niter=iter-1;
% plot(NF,'r-')
hold off


% %figure
% hold on
% % for k=1:nuser
% % plot(R_co(k,:))
% % end
% plot(R_co(1,:),'c:')
% plot(R_co(2,:),'g-.')
% plot(R_co(3,:),'k--')
% hold off
% 
% Increase=R_co(:,niter)-R_NE;
% Percent=Increase./R_NE;