%VBAKF_PREDICT_1D  1D Variational Bayesian Adaptive Kalman Filter prediction step
%
% Syntax:
%   [M,P,ALPHA,BETA] = VBAKF_PREDICT_1D(M,P,A,Q,ALPHA,BETA,LAMBDA)
%
% Author:
%   Simo Srkk, 2006
%
% In:
%       M - Nx1 mean state estimate after prediction step
%       P - NxN state covariance after prediction step
%       A - Transition matrix of discrete model (optional, default identity)
%       Q - Process noise of discrete model     (optional, default zero)
%   ALPHA - Inv-Gamma prior parameter alpha of noise variance
%    BETA - Inv-Gamma prior parameter beta of noise variance
%  LAMBDA - Dynamic coefficient (0,1]
%
% Out:
%       M - Predicted state mean
%       P - Predicted state covariance
%   ALPHA - Predicted parameter alpha
%    BETA - Predicted parameter beta
%
% Description:
%   ... No prediction is done if a <= 2.

function [m,P,a,b] = vbakf_predict_1d(m,P,A,Q,a,b,lambda)

  [m,P] = kf_predict(m,P,A,Q);
    
%  if (a > 2)
%    E = b/(a-1);
%    V = b^2/(a-1)^2/(a-2) + rq;
%    a = 2 + E^2/V;
%    b = E + E^3/V;
%  end

%  if (a > 1)
%    E = b/(a-1);
%    b = bc * b;
%    a = b/E + 1;
%  end
  
%  if (a > 1)
%    M = b/(a+1);
%    b = bc * b;
%    a = b/M - 1;
%  end

  a = lambda*a;
  b = lambda*b;
