%EQF_SS  Discretize given equalizer filter and convert to SS model
%
% Syntax:
%   [A,B,C] = eqf_ss(a1,a2,b1,b2,c,w0,T,n,int_n)
%
% In:
%   a1 - Numerator coefficient
%   a2 - Numerator coefficient
%   b1 - Denominator coefficient
%   b2 - Denominator coefficient
%   c  - Input coefficient
%   w0 - Angular velocity
%   T  - Sampling period
%   n  - Order of input approximation
%   int_n - Simpson's rule integration steps (default 10)
%
% Out:
%   A  - Transition matrix
%   BL - 2x(2n+1) matrix of 2x1 input matrices
%
% Desciption:
%   Discretize given equalizer filter and convert to SS model.
%   This is mainly meant for analysis purposes.

function [A,B,C,TA,BL] = eqf_ss(a1,a2,b1,b2,c,w0,T,n,int_n)

  if nargin < 9
      int_n = [];
  end

  [TA,BL] = eqf_disc(a1,a2,b1,b2,w0,T,n,int_n);

  A = zeros(2*n+2,2*n+2);
  A(1:2,1:2) = TA;
  for i=1:2*n
      if i < 2*n
        A(2+i,3+i) = 1;
      end
      A(1:2,end-i+1) = BL(:,1+i);
  end
  B = zeros(size(A,1),1);
  B(1:2,1) = BL(:,1);
  B(end,1) = 1;
  
  C = zeros(1,size(A,1));
  C(1) = 1;
  C(end-n+1) = c;

  