%
% First compare indivisual filters
%

  fs = 44100;
  db = 12;
  f0 = fs/6;
  Q  = 1;
  n  = 10;
  
  %ty = 'lowpass';
  %ty = 'highpass';
  %ty ='bandpass';
  %ty = 'notch';
  %ty = 'allpass';
  ty = 'peak';
  %ty = 'lowshelf';
  %ty = 'highshelf';

  [BC,AC] = eq_design_analog(ty,f0,Q,db);
  [B1,A1] = eq_design_cookbook(ty,fs,f0,Q,db);
  [TA,BL,B2,A2,c,AA,BB,CC] = eq_design_new(ty,fs,f0,Q,db,n,30);
  [B3,A3,G0,G,GB] = eq_design_orfanidis(fs,f0,Q,db);

  G = tf(B2,A2,1/fs);
  
  bodemag(tf(BC,AC),tf(B1,A1,1/fs),tf(B3,A3,1/fs),G);
  legend('Analog','Cookbook','Orfanidis','New design');
  pause;
  
%%
%
% Compare the full eq
%

  fs = 44100;
  n  = 10;
  
  dbL = 8;
  f0L = 100;
  QL  = 1;

  dbP = 3;
  f0P = 1000;
  QP  = 2;

  dbH = 12;
  f0H = 10000;
  QH  = 1;

  ty = 'lowshelf';
  [BCL,ACL] = eq_design_analog(ty,f0L,QL,dbL);
  [B1L,A1L] = eq_design_cookbook(ty,fs,f0L,QL,dbL);
  [TAL,BLL,B2L,A2L,cL,AAL,BBL,CCL] = eq_design_new(ty,fs,f0L,QL,dbL,n,30);

  ty = 'peak';
  [BCP,ACP] = eq_design_analog(ty,f0P,QP,dbP);
  [B1P,A1P] = eq_design_cookbook(ty,fs,f0P,QP,dbP);
  [TAP,BLP,B2P,A2P,cP,AAP,BBP,CCP] = eq_design_new(ty,fs,f0P,QP,dbP,n,30);

  ty = 'highshelf';
  [BCH,ACH] = eq_design_analog(ty,f0H,QH,dbH);
  [B1H,A1H] = eq_design_cookbook(ty,fs,f0H,QH,dbH);
  [TAH,BLH,B2H,A2H,cH,AAH,BBH,CCH] = eq_design_new(ty,fs,f0H,QH,dbH,n,30);

  GA = tf(BCL,ACL) * tf(BCP,ACP) * tf(BCH,ACH);
  GC = tf(B1L,A1L,1/fs) * tf(B1P,A1P,1/fs) * tf(B1H,A1H,1/fs);
  GN = tf(B2L,A2L,1/fs) * tf(B2P,A2P,1/fs) * tf(B2H,A2H,1/fs);
  
  bodemag(GA,GC,GN);
  legend('Analog','Cookbook','New design');
  pause;
  
