
(* Hash table *)

signature TABLE =
  sig
      type (''a,'b) table
      exception NotFound of string
      val create : (''a -> int) * int * (''a -> string) -> (''a,'b) table
      val add : (''a,'b) table * ''a * 'b -> (''a,'b) table
      val lookup : (''a,'b) table * ''a -> 'b
      val elements : (''a,'b) table -> (''a * 'b) list
      val elementcount : (''a,'b) table -> int
      val debugout : (''a,'b) table -> unit
  end;

structure Table : TABLE =
  struct

  type (''a,'b) table = (''a -> int) * int * (''a * 'b) list Array.array * (''a -> string) * int ref


    fun create (hash,size,key2string) = (hash,size,Array.array(size,[]),key2string,ref 0)

    fun add ((h,s,a,k2s,r),key,data) =
	let
	    val index = (h key) mod s
	    val l = Array.sub(a,index)
	    fun add (k,d,[]) = [(k,d)]
	      | add (k,d,(k2,d2)::es) = if k=k2 then (k,d)::es
					else (k2,d2)::(add(k,d,es))
	    val newl = add(key,data,l)
	in
	    Array.update(a,index,newl);
	    r := !r + 1;
	    (h,s,a,k2s,r)
	end
	handle Overflow => ERRORl [Int.toString (h key)," OVERFLOW"]
    
    exception NotFound of string

    fun lookup ((h,s,a,k2s,r),key) =
	let
	    val index = (h key) mod s
	    val l = Array.sub(a,index)
	in
	    (assoc(key,l)) handle Match => raise NotFound (k2s key)
	end
	handle Overflow => ERRORl [Int.toString (h key)," OVERFLOW2"]

    fun elements (_,_,a,_,_) = Array.foldl (op @) [] a
    fun elementcount (_,_,_,_,r) = !r

    fun debugout (_,_,a,_,ref els) =
      (app print ["ELEMENTS IN TABLE: ",Int.toString els,
		  "\n"];
       app (fn (a,b) =>
	       app print ["ELEMENT :",
			  "\n"])
	   (Array.foldl (op @) [] a)
      )
  
  end;

(* Symboltable for associating objects with an integer index and a value.
   The integer indices are assigned consecutively starting from 0.
 *)

signature SYMBOLTABLE =
  sig
    type (''a,'b) symboltable
    val create : (''a -> int) * int * (''a -> string) -> (''a,'b) symboltable
    val add : (''a,'b) symboltable * ''a * 'b -> int
    val lookup : (''a,'b) symboltable * ''a -> int * 'b
(*     val name : ''a symboltable * int -> ''a *)
    val reserve : (''a,'b) symboltable -> int * (''a,'b) symboltable
    val reserveN : (''a,'b) symboltable * int -> int * (''a,'b) symboltable
    val valuelookup : (''a,'b) symboltable -> (int -> 'b)
    val keylookup : (''a,'b) symboltable -> (int -> ''a)
    val allvalues : (''a,'b) symboltable -> (''a * int * 'b) list
    val maxvalue : (''a,'b) symboltable -> int
    val debugout : (''a,'b) symboltable -> unit
  end;

structure SymbolTable : SYMBOLTABLE =
  struct
    type (''a,'b) symboltable = (''a,int * 'b) Table.table * int ref
    fun create (h,n,sf) = (Table.create(h,n,sf),ref 0)
    fun add (st as (t,max),s,value) =
      (p12(Table.lookup (t,s))) handle Table.NotFound keystr => (max := !max + 1 ;
								 Table.add(t,s,(!max-1,value));
								 !max-1)
    fun lookup ((t,_),s) = Table.lookup (t,s)

    fun reserve (st as (t,rmax)) = (rmax := (!rmax)+1;(!rmax-1,st))
    fun reserveN (st as (t,rmax),rsv) = (rmax := (!rmax)+rsv;(!rmax+rsv-1,st))

    fun valuelookup (t,ref max) =
	(case Table.elements t of
	     [] => (fn _ => raise Match)
	   | (e::es) =>
	     let
		 val v0 = p22(p22 e)
		 val a = Array.array (max,v0)
		 val _ = app (fn (k,(i,v)) => Array.update(a,i,v)) es
	     in
		 (fn i => Array.sub(a,i))
	     end)

    fun keylookup (t,ref max) =
	(case Table.elements t of
	     [] => (fn _ => raise Match)
	   | (e::es) =>
	     let
		 val k0 = p12 e
		 val a = Array.array (max,k0)
		 val _ = app (fn (k,(i,v)) => Array.update(a,i,k)) es
	     in
		 (fn i => Array.sub(a,i))
	     end)

    fun allvalues (t,ref max) =
	map (fn (a,(b,c)) => (a,b,c)) (Table.elements t)
	     
    fun maxvalue (t,ref max) = max

    fun debugout (t,ref max) =
      (app print ["SYMBOLTABLE CONTENTS:\nmax = ",Int.toString max,"\n"];
       Table.debugout t)
	  
  end;
