functor SATSOLVERLrValsFun(structure Token : TOKEN)
 : sig structure ParserData : PARSER_DATA
       structure Tokens : SATSOLVER_TOKENS
   end
 = 
struct
structure ParserData=
struct
structure Header = 
struct
(*#line 1.2 "parser.sml"*)
(* 2017 (C) Jussi Rintanen *)

fun int2lit n = if n < 0 then Neg(0-n-1) else Pos(n-1)

fun fix n = if n < 0 then ERROR ("fixing "^(Int.toString n)) else n-1
fun lfix n = if n < 0 then Neg(0-n-1) else Pos(n-1)

fun fixclause [0] = []
  | fixclause (0::c) = ERROR "NULL literal in clause"
  | fixclause (n::c) = (int2lit n)::(fixclause c)

fun lfix3last (s,t,v) = (s,t,lfix v)
fun fix3fst (v,s,t) = (fix v,s,t)
fun lfix2last (s,v) = (s,lfix v)


datatype nodearc = NODE of int * int | ARC of int * int * int
fun getnodes na = fold (fn (NODE n,ac) => n::ac | (_,ac) => ac) na []
fun getarcs na = fold (fn (ARC a,ac) => a::ac | (_,ac) => ac) na []
				       

(*#line 33.1 "parser.sml.sml"*)
end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\014\000\000\000\
\\001\000\002\000\011\000\003\000\010\000\004\000\009\000\008\000\008\000\
\\009\000\007\000\010\000\006\000\000\000\
\\001\000\002\000\015\000\000\000\
\\001\000\002\000\016\000\000\000\
\\001\000\002\000\017\000\000\000\
\\001\000\002\000\018\000\000\000\
\\001\000\002\000\021\000\000\000\
\\001\000\002\000\024\000\000\000\
\\001\000\002\000\026\000\000\000\
\\001\000\002\000\029\000\000\000\
\\001\000\002\000\032\000\000\000\
\\001\000\002\000\040\000\000\000\
\\001\000\002\000\041\000\000\000\
\\001\000\002\000\044\000\000\000\
\\001\000\002\000\045\000\000\000\
\\001\000\002\000\047\000\000\000\
\\001\000\002\000\048\000\000\000\
\\001\000\002\000\049\000\000\000\
\\001\000\005\000\043\000\000\000\
\\001\000\006\000\036\000\007\000\035\000\000\000\
\\001\000\011\000\012\000\000\000\
\\001\000\011\000\020\000\000\000\
\\001\000\011\000\025\000\000\000\
\\001\000\011\000\031\000\000\000\
\\001\000\011\000\037\000\000\000\
\\001\000\011\000\039\000\000\000\
\\001\000\011\000\046\000\000\000\
\\001\000\011\000\050\000\000\000\
\\001\000\011\000\051\000\000\000\
\\001\000\012\000\000\000\000\000\
\\053\000\000\000\
\\054\000\000\000\
\\055\000\002\000\011\000\003\000\010\000\004\000\009\000\008\000\008\000\
\\009\000\007\000\010\000\006\000\000\000\
\\056\000\000\000\
\\057\000\000\000\
\\058\000\000\000\
\\059\000\000\000\
\\060\000\000\000\
\\061\000\000\000\
\\062\000\000\000\
\\063\000\002\000\024\000\000\000\
\\064\000\000\000\
\\065\000\000\000\
\\066\000\000\000\
\\067\000\002\000\029\000\000\000\
\\068\000\000\000\
\\069\000\002\000\011\000\000\000\
\\070\000\000\000\
\\071\000\006\000\036\000\007\000\035\000\000\000\
\\072\000\000\000\
\\073\000\000\000\
\"
val actionRowNumbers =
"\001\000\020\000\030\000\032\000\
\\000\000\002\000\003\000\004\000\
\\005\000\046\000\033\000\031\000\
\\021\000\006\000\007\000\022\000\
\\008\000\045\000\038\000\009\000\
\\040\000\023\000\010\000\019\000\
\\024\000\044\000\025\000\011\000\
\\039\000\036\000\012\000\048\000\
\\018\000\013\000\014\000\034\000\
\\043\000\037\000\042\000\041\000\
\\047\000\026\000\015\000\016\000\
\\035\000\017\000\027\000\028\000\
\\050\000\049\000\029\000"
val gotoT =
"\
\\001\000\003\000\002\000\002\000\009\000\001\000\010\000\050\000\000\000\
\\000\000\
\\000\000\
\\001\000\003\000\002\000\011\000\009\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\017\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\005\000\021\000\006\000\020\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\026\000\008\000\025\000\000\000\
\\005\000\028\000\006\000\020\000\000\000\
\\000\000\
\\000\000\
\\003\000\032\000\004\000\031\000\000\000\
\\000\000\
\\007\000\036\000\008\000\025\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\040\000\004\000\031\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 51
val numrules = 21
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
       fun f i =
            if i=numstates then g i
            else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in f 0 handle Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit ->  unit | CINT of unit ->  (int) | INT of unit ->  (int) | ID of unit ->  (string) | instance of unit ->  (entry list) | intlist of unit ->  (int list) | intpair of unit ->  (int*int) | intpairs of unit ->  ( ( int * int )  list) | inttriple of unit ->  (int*int*int) | inttriples of unit ->  ( ( int * int * int )  list) | nodearc of unit ->  (nodearc) | nodearcs of unit ->  (nodearc list) | entrylist of unit ->  (entry list) | entry of unit ->  (entry)
end
type svalue = MlyValue.svalue
type result = entry list
end
structure EC=
struct
open LrTable
infix 5 $$
fun x $$ y = y::x
val is_keyword =
fn _ => false
val preferred_change : (term list * term list) list = 
nil
val noShift = 
fn (T 11) => true | _ => false
val showTerminal =
fn (T 0) => "ID"
  | (T 1) => "INT"
  | (T 2) => "PCNF"
  | (T 3) => "CGRAPH"
  | (T 4) => "CENDGRAPH"
  | (T 5) => "CNODE"
  | (T 6) => "CARC"
  | (T 7) => "CNONREACH"
  | (T 8) => "CREACHABLE"
  | (T 9) => "CINT"
  | (T 10) => "NEWLINE"
  | (T 11) => "EOF"
  | _ => "bogus-term"
local open Header in
val errtermvalue=
fn (T 0) => MlyValue.ID(fn () => ("bogus")) | 
_ => MlyValue.VOID
end
val terms : term list = nil
 $$ (T 11) $$ (T 10) $$ (T 8) $$ (T 7) $$ (T 6) $$ (T 5) $$ (T 4) $$ (T 3) $$ (T 2)end
structure Actions =
struct 
exception mlyAction of int
local open Header in
val actions = 
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of  ( 0, ( ( _, ( MlyValue.entrylist entrylist1, entrylist1left, entrylist1right)) :: rest671)) => let val  result = MlyValue.instance (fn _ => let val  (entrylist as entrylist1) = entrylist1 ()
 in ((*#line 52.23 "parser.sml"*)entrylist(*#line 270.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 9, ( result, entrylist1left, entrylist1right), rest671)
end
|  ( 1, ( ( _, ( MlyValue.entrylist entrylist1, _, entrylist1right)) :: ( _, ( MlyValue.entry entry1, entry1left, _)) :: rest671)) => let val  result = MlyValue.entrylist (fn _ => let val  (entry as entry1) = entry1 ()
 val  (entrylist as entrylist1) = entrylist1 ()
 in ((*#line 53.30 "parser.sml"*)entry::entrylist(*#line 276.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 1, ( result, entry1left, entrylist1right), rest671)
end
|  ( 2, ( ( _, ( MlyValue.entry entry1, entry1left, entry1right)) :: rest671)) => let val  result = MlyValue.entrylist (fn _ => let val  (entry as entry1) = entry1 ()
 in ((*#line 54.11 "parser.sml"*)[entry](*#line 283.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 1, ( result, entry1left, entry1right), rest671)
end
|  ( 3, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.intlist intlist1, intlist1left, _)) :: rest671)) => let val  result = MlyValue.entry (fn _ => let val  (intlist as intlist1) = intlist1 ()
 in ((*#line 56.26 "parser.sml"*)Clause (fixclause intlist)(*#line 289.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, intlist1left, NEWLINE1right), rest671)
end
|  ( 4, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.INT INT2, _, _)) :: ( _, ( MlyValue.INT INT1, _, _)) :: ( _, ( _, PCNF1left, _)) :: rest671)) => let val  result = MlyValue.entry (fn _ => let val  INT1 = INT1 ()
 val  INT2 = INT2 ()
 in ((*#line 57.26 "parser.sml"*)Pcnf(INT1,INT2)(*#line 295.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, PCNF1left, NEWLINE1right), rest671)
end
|  ( 5, ( ( _, ( _, _, NEWLINE2right)) :: _ :: ( _, ( MlyValue.nodearcs nodearcs1, _, _)) :: _ :: ( _, ( MlyValue.INT INT1, _, _)) :: ( _, ( _, CGRAPH1left, _)) :: rest671)) => let val  result = MlyValue.entry (fn _ => let val  (INT as INT1) = INT1 ()
 val  (nodearcs as nodearcs1) = nodearcs1 ()
 in ((*#line 58.51 "parser.sml"*)Cgraph(INT,getnodes nodearcs,map fix3fst (getarcs nodearcs))(*#line 302.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, CGRAPH1left, NEWLINE2right), rest671)
end
|  ( 6, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.inttriples inttriples1, _, _)) :: ( _, ( MlyValue.INT INT1, _, _)) :: ( _, ( _, CNONREACH1left, _)) :: rest671)) => let val  result = MlyValue.entry (fn _ => let val  INT1 = INT1 ()
 val  (inttriples as inttriples1) = inttriples1 ()
 in ((*#line 59.38 "parser.sml"*)Cnonreach(INT1,map lfix3last inttriples)(*#line 309.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, CNONREACH1left, NEWLINE1right), rest671)
end
|  ( 7, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.intpairs intpairs1, _, _)) :: ( _, ( MlyValue.INT INT2, _, _)) :: ( _, ( MlyValue.INT INT1, _, _)) :: ( _, ( _, CREACHABLE1left, _)) :: rest671)) => let val  result = MlyValue.entry (fn _ => let val  INT1 = INT1 ()
 val  INT2 = INT2 ()
 val  (intpairs as intpairs1) = intpairs1 ()
 in ((*#line 60.41 "parser.sml"*)Creachable(INT1,INT2,map lfix2last intpairs)(*#line 316.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, CREACHABLE1left, NEWLINE1right), rest671)
end
|  ( 8, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.ID ID1, _, _)) :: ( _, ( MlyValue.CINT CINT1, CINT1left, _)) :: rest671)) => let val  result = MlyValue.entry (fn _ => let val  (CINT as CINT1) = CINT1 ()
 val  (ID as ID1) = ID1 ()
 in ((*#line 61.21 "parser.sml"*)Csymtab(CINT,ID)(*#line 324.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, CINT1left, NEWLINE1right), rest671)
end
|  ( 9, ( ( _, ( MlyValue.inttriples inttriples1, _, inttriples1right)) :: ( _, ( MlyValue.inttriple inttriple1, inttriple1left, _)) :: rest671)) => let val  result = MlyValue.inttriples (fn _ => let val  (inttriple as inttriple1) = inttriple1 ()
 val  (inttriples as inttriples1) = inttriples1 ()
 in ((*#line 63.36 "parser.sml"*)inttriple::inttriples(*#line 331.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 4, ( result, inttriple1left, inttriples1right), rest671)
end
|  ( 10, ( ( _, ( MlyValue.inttriple inttriple1, inttriple1left, inttriple1right)) :: rest671)) => let val  result = MlyValue.inttriples (fn _ => let val  (inttriple as inttriple1) = inttriple1 ()
 in ((*#line 64.15 "parser.sml"*)[inttriple](*#line 338.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 4, ( result, inttriple1left, inttriple1right), rest671)
end
|  ( 11, ( ( _, ( MlyValue.INT INT3, _, INT3right)) :: ( _, ( MlyValue.INT INT2, _, _)) :: ( _, ( MlyValue.INT INT1, INT1left, _)) :: rest671)) => let val  result = MlyValue.inttriple (fn _ => let val  INT1 = INT1 ()
 val  INT2 = INT2 ()
 val  INT3 = INT3 ()
 in ((*#line 66.26 "parser.sml"*)INT1,INT2,INT3(*#line 344.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 5, ( result, INT1left, INT3right), rest671)
end
|  ( 12, ( ( _, ( MlyValue.INT INT2, _, INT2right)) :: ( _, ( MlyValue.INT INT1, INT1left, _)) :: rest671)) => let val  result = MlyValue.intpair (fn _ => let val  INT1 = INT1 ()
 val  INT2 = INT2 ()
 in ((*#line 67.20 "parser.sml"*)INT1,INT2(*#line 352.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 7, ( result, INT1left, INT2right), rest671)
end
|  ( 13, ( ( _, ( MlyValue.intpairs intpairs1, _, intpairs1right)) :: ( _, ( MlyValue.intpair intpair1, intpair1left, _)) :: rest671)) => let val  result = MlyValue.intpairs (fn _ => let val  (intpair as intpair1) = intpair1 ()
 val  (intpairs as intpairs1) = intpairs1 ()
 in ((*#line 69.30 "parser.sml"*)intpair::intpairs(*#line 359.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 6, ( result, intpair1left, intpairs1right), rest671)
end
|  ( 14, ( ( _, ( MlyValue.intpair intpair1, intpair1left, intpair1right)) :: rest671)) => let val  result = MlyValue.intpairs (fn _ => let val  (intpair as intpair1) = intpair1 ()
 in ((*#line 70.13 "parser.sml"*)[intpair](*#line 366.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 6, ( result, intpair1left, intpair1right), rest671)
end
|  ( 15, ( ( _, ( MlyValue.intlist intlist1, _, intlist1right)) :: ( _, ( MlyValue.INT INT1, INT1left, _)) :: rest671)) => let val  result = MlyValue.intlist (fn _ => let val  (INT as INT1) = INT1 ()
 val  (intlist as intlist1) = intlist1 ()
 in ((*#line 72.24 "parser.sml"*)INT::intlist(*#line 372.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 8, ( result, INT1left, intlist1right), rest671)
end
|  ( 16, ( ( _, ( MlyValue.INT INT1, INT1left, INT1right)) :: rest671)) => let val  result = MlyValue.intlist (fn _ => let val  (INT as INT1) = INT1 ()
 in ((*#line 73.9 "parser.sml"*)[INT](*#line 379.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 8, ( result, INT1left, INT1right), rest671)
end
|  ( 17, ( ( _, ( MlyValue.nodearcs nodearcs1, _, nodearcs1right)) :: ( _, ( MlyValue.nodearc nodearc1, nodearc1left, _)) :: rest671)) => let val  result = MlyValue.nodearcs (fn _ => let val  (nodearc as nodearc1) = nodearc1 ()
 val  (nodearcs as nodearcs1) = nodearcs1 ()
 in ((*#line 76.30 "parser.sml"*)nodearc::nodearcs(*#line 385.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, nodearc1left, nodearcs1right), rest671)
end
|  ( 18, ( ( _, ( MlyValue.nodearc nodearc1, nodearc1left, nodearc1right)) :: rest671)) => let val  result = MlyValue.nodearcs (fn _ => let val  (nodearc as nodearc1) = nodearc1 ()
 in ((*#line 77.13 "parser.sml"*)[nodearc](*#line 392.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, nodearc1left, nodearc1right), rest671)
end
|  ( 19, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.INT INT3, _, _)) :: ( _, ( MlyValue.INT INT2, _, _)) :: ( _, ( MlyValue.INT INT1, _, _)) :: ( _, ( _, CARC1left, _)) :: rest671)) => let val  result = MlyValue.nodearc (fn _ => let val  INT1 = INT1 ()
 val  INT2 = INT2 ()
 val  INT3 = INT3 ()
 in ((*#line 78.37 "parser.sml"*)ARC(INT1,INT2,INT3)(*#line 398.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 3, ( result, CARC1left, NEWLINE1right), rest671)
end
|  ( 20, ( ( _, ( _, _, NEWLINE1right)) :: ( _, ( MlyValue.INT INT2, _, _)) :: ( _, ( MlyValue.INT INT1, _, _)) :: ( _, ( _, CNODE1left, _)) :: rest671)) => let val  result = MlyValue.nodearc (fn _ => let val  INT1 = INT1 ()
 val  INT2 = INT2 ()
 in ((*#line 79.27 "parser.sml"*)NODE(INT1,INT2)(*#line 406.1 "parser.sml.sml"*)
)
end)
 in ( LrTable.NT 3, ( result, CNODE1left, NEWLINE1right), rest671)
end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.instance x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a ()
end
end
structure Tokens : SATSOLVER_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(ParserData.MlyValue.ID (fn () => i),p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(ParserData.MlyValue.INT (fn () => i),p1,p2))
fun PCNF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(ParserData.MlyValue.VOID,p1,p2))
fun CGRAPH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(ParserData.MlyValue.VOID,p1,p2))
fun CENDGRAPH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(ParserData.MlyValue.VOID,p1,p2))
fun CNODE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(ParserData.MlyValue.VOID,p1,p2))
fun CARC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(ParserData.MlyValue.VOID,p1,p2))
fun CNONREACH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(ParserData.MlyValue.VOID,p1,p2))
fun CREACHABLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(ParserData.MlyValue.VOID,p1,p2))
fun CINT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(ParserData.MlyValue.CINT (fn () => i),p1,p2))
fun NEWLINE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(ParserData.MlyValue.VOID,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(ParserData.MlyValue.VOID,p1,p2))
end
end
