
(* 2017 (C) Jussi Rintanen *)

fun int2lit n = if n < 0 then Neg(0-n-1) else Pos(n-1)

fun fix n = if n < 0 then ERROR ("fixing "^(Int.toString n)) else n-1
fun lfix n = if n < 0 then Neg(0-n-1) else Pos(n-1)

fun fixclause [0] = []
  | fixclause (0::c) = ERROR "NULL literal in clause"
  | fixclause (n::c) = (int2lit n)::(fixclause c)

fun lfix3last (s,t,v) = (s,t,lfix v)
fun fix3fst (v,s,t) = (fix v,s,t)
fun lfix2last (s,v) = (s,lfix v)


datatype nodearc = NODE of int * int | ARC of int * int * int
fun getnodes na = fold (fn (NODE n,ac) => n::ac | (_,ac) => ac) na []
fun getarcs na = fold (fn (ARC a,ac) => a::ac | (_,ac) => ac) na []
				       
%%

%eop EOF

(* %pos declares the type of positions for terminals.
   Each symbol has an associated left and right position. *)

%pos int


%term ID of string | INT of int | PCNF | CGRAPH | CENDGRAPH | CNODE | CARC | CNONREACH | CREACHABLE | CINT of int | NEWLINE | EOF

%nonterm entry of entry
		| entrylist of entry list
		| nodearcs of nodearc list
		| nodearc of nodearc
		| inttriples of (int * int * int) list
		| inttriple of int * int * int
		| intpairs of (int * int) list
		| intpair of int * int
		| intlist of int list
		| instance of entry list
%name SATSOLVER

%noshift EOF
%value ID ("bogus")
%verbose
%start instance
%%

instance	: entrylist (entrylist)
entrylist : entry entrylist (entry::entrylist)
	| entry ([entry])

entry	: intlist NEWLINE (Clause (fixclause intlist))
	| PCNF INT INT NEWLINE (Pcnf(INT1,INT2))
	| CGRAPH INT NEWLINE nodearcs CENDGRAPH NEWLINE (Cgraph(INT,getnodes nodearcs,map fix3fst (getarcs nodearcs)))
	| CNONREACH INT inttriples NEWLINE (Cnonreach(INT1,map lfix3last inttriples))
	| CREACHABLE INT INT intpairs NEWLINE (Creachable(INT1,INT2,map lfix2last intpairs))
	| CINT ID NEWLINE (Csymtab(CINT,ID))

inttriples : inttriple inttriples (inttriple::inttriples)
	| inttriple ([inttriple])

inttriple : INT INT INT (INT1,INT2,INT3)
intpair : INT INT (INT1,INT2)

intpairs : intpair intpairs (intpair::intpairs)
	| intpair ([intpair])

intlist : INT intlist (INT::intlist)
	| INT ([INT])
				

nodearcs : nodearc nodearcs (nodearc::nodearcs)
	| nodearc ([nodearc])
nodearc : CARC INT INT INT NEWLINE (ARC(INT1,INT2,INT3))
	| CNODE INT INT NEWLINE (NODE(INT1,INT2))
