
(* 2017 (C) Jussi Rintanen *)

open Tokens
val linenum = ref 1
val error = fn x => print(x ^ "\n")
val eof = fn () => EOF (0,1)
type pos = int
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult = (svalue,pos) token

fun p13(v,_,_) = v

fun drop2 s = String.extract(s,2,NONE)

(* "c "([^\n].*\n) => (lex()); REMOVED *)


%%

alpha=[A-Za-z];
alpnum=[0-9A-Za-z_\(\),];
num=[0-9];
ws = [\ \t];

%header (functor SATSOLVERLexFun(structure Tokens : SATSOLVER_TOKENS));

%%
\n       => (linenum := !linenum + 1; NEWLINE(yypos,yypos+1));

"p cnf" => (PCNF(yypos,yypos+1));
"c graph " => (CGRAPH(yypos,yypos+1));
"c endgraph" => (CENDGRAPH(yypos,yypos+1));
"c node " => (CNODE(yypos,yypos+1));
"c arc " => (CARC(yypos,yypos+1));
"c gnonreach " => (CNONREACH(yypos,yypos+1));
"c grnonreach " => (CNONREACH(yypos,yypos+1));
"c greachable " => (CREACHABLE(yypos,yypos+1));
"c "{num}+" " => (case Int.fromString(drop2 yytext) of
		      (SOME n) => CINT(n,yypos,yypos+1)
		    | NONE => (error("bad int in 'c INT'");lex()));

{ws}+    => (lex());

("-"?){num}+ => (case (Int.fromString (yytext)) of
	     (SOME n) => INT (n,yypos,yypos+1)
	   | _ => (error ("bad nat "^yytext);lex()));

{alpha}{alpnum}* => (ID (yytext,yypos,yypos+1));

.        => (error ("ignoring bad character "^yytext^":"^(fold (op ^) (map (fn c => " "^(Int.toString (ord c))) (explode yytext)) "")); lex());
